/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;

public final class AnalyzerConfigurationFile
extends NamedElement
implements IModifiableFile,
ISoftwareSystemDefinitionElement {
    private final IConfigurableAnalyzerId m_analyzerId;
    private final IModifiablePathListener m_listener;
    private boolean m_existsOnDisk;
    private long m_timestamp = -1L;
    private TFile m_file;
    private String m_fileId;
    private String m_relPath;
    private boolean m_needsSave;

    public static String getAnalyzerIdStandardName(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAnalyzerId' must not be empty";
        return FileUtility.removeExtension((String)identifyingPath).substring("./".length());
    }

    public static String getFileName(IAnalyzerId analyzerId) {
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'getFileName' must not be null";
        return analyzerId.getStandardName() + CoreFileType.ANALYZER_CONFIGURATION.getDefaultExtension();
    }

    @Override
    public String getImageResourceName() {
        return this.m_analyzerId.getConfigurationCreator().getImageResourceName();
    }

    private static TFile getFile(IBaseDirectory baseDirectory, IAnalyzerId analyzerId) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'getFile' must not be null";
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'getFile' must not be null";
        return new TFile((File)baseDirectory.getDirectoryFile(), AnalyzerConfigurationFile.getFileName(analyzerId));
    }

    public static String getName(IBaseDirectory baseDirectory, IAnalyzerId analyzerId) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'getName' must not be null";
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'getFileName' must not be null";
        TFile file = AnalyzerConfigurationFile.getFile(baseDirectory, analyzerId);
        return FileUtility.calculateRelativePath((TFile)file, (TFile)baseDirectory.getDirectoryFile());
    }

    public AnalyzerConfigurationFile(NamedElement parent, IConfigurableAnalyzerId id, TFile file, IModifiablePathListener listener) {
        super(parent);
        assert (id != null) : "Parameter 'id' of method 'AnalyzerConfigurationFile' must not be null";
        assert (file != null) : "Parameter 'file' of method 'AnalyzerConfigurationFile' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'AnalyzerConfigurationFile' must not be null";
        this.m_analyzerId = id;
        this.m_file = file.getNormalizedFile();
        this.m_timestamp = this.m_file.lastModified();
        this.m_existsOnDisk = file.exists();
        IBaseDirectory baseDir = this.getParent(IBaseDirectory.class, new Class[0]);
        assert (baseDir != null) : "'baseDir' of method 'reallocate' must not be null";
        this.m_relPath = FileUtility.calculateRelativePath((TFile)this.m_file, (TFile)baseDir.getDirectoryFile());
        this.createNewFileId();
        this.m_listener = listener;
        this.m_listener.created(this);
    }

    @Override
    public String getPresentationKind() {
        return "Analyzer Configuration";
    }

    @Override
    public boolean existsOnDisk() {
        return this.m_existsOnDisk;
    }

    public void setExistsOnDisk(boolean exists) {
        if (exists != this.m_existsOnDisk) {
            this.m_existsOnDisk = exists;
            this.m_listener.additionalInformationModified(this);
        }
    }

    @Override
    public long getTimestamp() {
        return this.m_timestamp;
    }

    public IAnalyzerId getAnalyzerId() {
        return this.m_analyzerId;
    }

    @Override
    public String getName() {
        return this.m_relPath;
    }

    @Override
    public String getShortName() {
        return this.getFile().getName();
    }

    @Override
    public TFile getFile() {
        return this.m_file;
    }

    @Override
    public String getIdentifyingPath() {
        return this.m_relPath;
    }

    @Override
    @Property
    public String getAbsolutePath() {
        return this.getFile().getNormalizedAbsolutePath();
    }

    @Override
    @Property
    public String getDescription() {
        return "Configuration for '" + this.m_analyzerId.getPresentationName() + "' analyzer";
    }

    public void setFile(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'setFile' must not be null";
        this.m_file = file.getNormalizedFile();
        this.m_timestamp = this.m_file.lastModified();
        this.m_existsOnDisk = file.exists();
        IBaseDirectory baseDir = this.getParent(IBaseDirectory.class, new Class[0]);
        assert (baseDir != null) : "'baseDir' of method 'reallocate' must not be null";
        this.m_relPath = FileUtility.calculateRelativePath((TFile)this.m_file, (TFile)baseDir.getDirectoryFile());
    }

    @Override
    public void reallocate() {
        IBaseDirectory baseDir = this.getParent(IBaseDirectory.class, new Class[0]);
        assert (baseDir != null) : "'baseDir' of method 'reallocate' must not be null";
        assert (FileUtility.isRelativePath((String)this.m_relPath));
        this.m_file = new TFile((File)baseDir.getDirectoryFile(), this.m_relPath).getNormalizedAbsoluteFile();
    }

    @Override
    public void createNewFileId() {
        this.m_fileId = StringUtility.createTimebasedId((String)this.m_relPath);
    }

    @Override
    public boolean needsSave() {
        return this.m_needsSave;
    }

    public void reloaded() {
        this.m_listener.reloaded(this);
        this.m_timestamp = this.getFile().lastModified();
        this.m_needsSave = false;
    }

    @Override
    public void setNeedsSave(boolean needsSave) {
        this.m_needsSave = needsSave;
        if (this.m_needsSave) {
            this.m_listener.modified(this);
        } else {
            this.m_listener.saved(this);
        }
    }

    @Override
    public void remove() {
        this.m_listener.deleted(this);
        super.remove();
    }

    @Override
    public void parentRemoved() {
        this.m_listener.deleted(this);
        super.parentRemoved();
    }

    @Override
    public String getFileId() {
        return this.m_fileId;
    }

    public void setTimeStamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.ANALYZER_CONFIGURATION;
    }

    @Override
    public void resetTimestamp() {
        this.setTimeStamp(this.getFile().lastModified());
    }
}

