/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.controller.system.treemap.ComponentAggregatorIntValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.IntValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.SizeValueAccessor;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.SizeAttribute;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.treemap.ISizeInfoProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapLeafElement;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class SizeIntMetricValueAccessor
extends SizeValueAccessor {
    private static final Map<TreeMapLeafElement, List<IMetricId>> SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS = new LinkedHashMap<TreeMapLeafElement, List<IMetricId>>();
    private final ISizeInfoProvider m_sizeInfoProvider = new ISizeInfoProvider(){

        @Override
        public String getInformation() {
            return SizeIntMetricValueAccessor.this.m_sizeAttribute.getName();
        }
    };
    private final SizeAttribute m_sizeAttribute;
    private final IntValueAdapter m_valueProvider;

    static {
        SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS.put(TreeMapLeafElement.PHYSICAL_SOURCE_FILE, Arrays.asList(CoreMetricId.CORE_LINES_OF_CODE, CoreMetricId.CORE_SOURCE_ELEMENT_COUNT));
        SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS.put(TreeMapLeafElement.PHYSICAL_COMPONENT, Arrays.asList(CoreMetricId.CORE_LINES_OF_CODE, CoreMetricId.CORE_SOURCE_ELEMENT_COUNT));
    }

    static Map<TreeMapLeafElement, List<IMetricId>> getSupportedSourceFileLevelMetricIds() {
        return Collections.unmodifiableMap(SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS);
    }

    SizeIntMetricValueAccessor(IMetricAccessor metricAccessor, SoftwareSystem system, IMetricDescriptor metricDescriptor, TreeMapLeafElement leafElement) {
        assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'MetricValueAccessor' must not be null";
        assert (system != null) : "Parameter 'system' of method 'SizeMetricValueAccessor' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'MetricValueAccessor' must not be null";
        assert (leafElement != null) : "Parameter 'leafElement' of method 'MetricValueAccessor' must not be null";
        IMetricId metricId = metricDescriptor.getMetricId();
        List<IMetricId> metricIds = SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS.get((Object)leafElement);
        assert (metricIds != null && !metricIds.isEmpty()) : "'metricIds' of method 'SizeMetricValueAccessor' must not be empty";
        assert (metricIds.contains(metricId)) : "Metric id not supported: " + String.valueOf(metricId);
        this.m_sizeAttribute = new SizeAttribute(metricId.getPresentationName());
        switch (leafElement) {
            case PHYSICAL_COMPONENT: {
                if (metricId == CoreMetricId.CORE_LINES_OF_CODE) {
                    this.m_valueProvider = new ComponentAggregatorIntValueAdapter(new SourceFileLinesOfCodeIntValueAdapter());
                    break;
                }
                this.m_valueProvider = new ComponentAggregatorIntValueAdapter(new SourceFileMetricIntValueAdapter(metricAccessor, system, metricDescriptor));
                break;
            }
            case PHYSICAL_SOURCE_FILE: {
                if (metricId == CoreMetricId.CORE_LINES_OF_CODE) {
                    this.m_valueProvider = new SourceFileLinesOfCodeIntValueAdapter();
                    break;
                }
                this.m_valueProvider = new SourceFileMetricIntValueAdapter(metricAccessor, system, metricDescriptor);
                break;
            }
            default: {
                assert (false) : "Unhandled leaf element: " + String.valueOf((Object)leafElement);
                this.m_valueProvider = null;
            }
        }
    }

    @Override
    SizeAttribute getSizeAttribute() {
        return this.m_sizeAttribute;
    }

    @Override
    ISizeInfoProvider getSizeInfoProvider() {
        return this.m_sizeInfoProvider;
    }

    @Override
    int getSizeValue(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getSize' must not be null";
        return this.m_valueProvider.getValue(element);
    }

    private static final class SourceFileLinesOfCodeIntValueAdapter
    extends IntValueAdapter {
        SourceFileLinesOfCodeIntValueAdapter() {
        }

        @Override
        public int getValue(NamedElement element) {
            assert (element != null && element instanceof SourceFile) : "Unexpected class in method 'get': " + String.valueOf(element);
            return ((SourceFile)element).getLinesOfCode();
        }
    }

    static final class SourceFileMetricIntValueAdapter
    extends IntValueAdapter {
        private final IMetricAccessor m_metricAccessor;
        private final SoftwareSystem m_system;
        private final IMetricDescriptor m_metricDescriptor;

        SourceFileMetricIntValueAdapter(IMetricAccessor metricAccessor, SoftwareSystem system, IMetricDescriptor metricDescriptor) {
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'SourceFileMetricId' must not be null";
            assert (system != null) : "Parameter 'system' of method 'SourceFileMetricId' must not be null";
            assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'SourceFileMetricId' must not be null";
            this.m_metricAccessor = metricAccessor;
            this.m_system = system;
            this.m_metricDescriptor = metricDescriptor;
        }

        @Override
        public int getValue(NamedElement element) {
            Number value;
            assert (element != null) : "Parameter 'element' of method 'getValue' must not be null";
            IMetricValue metricValue = this.m_metricAccessor.getMetricValue(this.m_system, (IWorkerContext)DefaultWorkerContext.INSTANCE, element, this.m_metricDescriptor, true);
            if (metricValue != null && (value = metricValue.getValue()) != null) {
                return value.intValue();
            }
            return -1;
        }
    }
}

