/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;

public final class AssignedElementMatcher
extends NamedElementVisitor
implements AssignedElement.IVisitor,
Artifact.IVisitor,
UnassignedElements.IVisitor {
    private final IAssignableToArtifact m_assignableToMatch;
    private final ArchitectureBaseElement m_elementForLookup;
    private AssignedElement m_matchingAssignedComponent;

    public AssignedElementMatcher(ArchitectureBaseElement elementForLookup, IAssignableToArtifact assignableToMatch) {
        assert (elementForLookup != null) : "Parameter 'elementForLookup' of method 'MatchingAssignedComponentFinderVisitor' must not be null";
        assert (assignableToMatch != null) : "Parameter 'assignableToMatch' of method 'MatchingAssignedComponentFinderVisitor' must not be null";
        this.m_elementForLookup = elementForLookup;
        this.m_assignableToMatch = assignableToMatch;
    }

    @Override
    public void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        if (this.m_matchingAssignedComponent == null) {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public void visitArtifact(Artifact element) {
        assert (element != null) : "Parameter 'element' of method 'visitArchitectureElement' must not be null";
        if (element.equals(this.m_elementForLookup)) {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public void visitUnassignedElements(UnassignedElements element) {
        assert (element != null) : "Parameter 'element' of method 'visitUnassignedComponents' must not be null";
        if (element.equals(this.m_elementForLookup)) {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public void visitAssignedElement(AssignedElement assignedComponent) {
        assert (assignedComponent != null) : "Parameter 'assignedComponent' of method 'visitAssignedComponent' must not be null";
        if (assignedComponent.getRepresentedElement().equals(this.m_assignableToMatch.getNamedElement())) {
            this.m_matchingAssignedComponent = assignedComponent;
            this.done();
        }
    }

    @Override
    public void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        for (NamedElement namedElement : element.getAllChildren()) {
            if (namedElement instanceof Interface || namedElement instanceof Connector) continue;
            namedElement.accept(this);
        }
    }

    public AssignedElement getMatchingAssignedComponent() {
        return this.m_matchingAssignedComponent;
    }
}

