/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.progress;

import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public class ProgressDaemon
implements Runnable {
    private final IWorkerContext m_workerContext;
    private final int m_incrementInMs;
    private final Thread m_progressThread;
    private int m_counter = 0;
    private boolean m_finished = false;

    public ProgressDaemon(IWorkerContext workerContext, double totalTimeInMs) {
        this.m_workerContext = workerContext;
        this.m_incrementInMs = (int)(totalTimeInMs / 100.0) + 1;
        this.m_progressThread = new Thread(() -> this.run());
        this.m_progressThread.start();
        this.m_workerContext.beginBlockOfWork(100);
    }

    @Override
    public void run() {
        try {
            while (!this.m_finished && this.m_counter < 99) {
                Thread.sleep(this.m_incrementInMs);
                ++this.m_counter;
                this.m_workerContext.workItemCompleted();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void finish() {
        this.m_finished = true;
        try {
            this.m_progressThread.join();
        }
        catch (InterruptedException interruptedException) {}
        while (this.m_counter < 100) {
            this.m_workerContext.workItemCompleted();
            ++this.m_counter;
        }
    }
}

