/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.base;

import com.hello2morrow.javapg.runtime.lexer.base.ILexer;
import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.core.model.common.IFormatter;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Formatter
implements IFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Formatter.class);
    private final FormatterOptions m_options;
    private final Pair<Integer, Integer> m_l_r_braces;

    protected Formatter(FormatterOptions options, Pair<Integer, Integer> L_R_Braces) {
        assert (options != null) : "Parameter 'options' of method 'AbstractFormatter' must not be null";
        assert (L_R_Braces != null) : "Parameter 'L_R_Braces' of method 'Formatter' must not be null";
        this.m_options = options;
        this.m_l_r_braces = L_R_Braces;
    }

    protected Formatter(Pair<Integer, Integer> L_R_Braces) {
        this(new FormatterOptions(), L_R_Braces);
    }

    @Override
    public final FormatterOptions getOptions() {
        return this.m_options;
    }

    protected abstract ILexer getLexer();

    @Override
    public final Pair<String, Integer> getIndentationAfterNewline(String source, int offset) {
        boolean isNextCharClosingCurlyBrace;
        assert (source != null) : "Parameter 'source' of method 'getIndentationAfterNewline' must not be null";
        assert (offset >= 0) : "Parameter 'offset' of method 'getIndentationAfterNewline' must not be negative";
        assert (offset <= source.length()) : "Parameter 'offset' of method 'getIndentationAfterNewline' must not be greater than source.length()";
        ILexer lexer = this.getLexer();
        lexer.assignInput((Reader)new StringReader(source), "String Lexer");
        int level = this.moveLexerToOffset(lexer, offset);
        boolean isNextCharOpeningCurlyBrace = source.length() >= offset + 1 && source.charAt(offset) == '{';
        boolean bl = isNextCharClosingCurlyBrace = source.length() >= offset + 1 && source.charAt(offset) == '}';
        if (!isNextCharOpeningCurlyBrace && !isNextCharClosingCurlyBrace) {
            String indentation = this.createIndentation(level);
            return new Pair((Object)indentation, (Object)(offset + indentation.length() + 1));
        }
        if (isNextCharOpeningCurlyBrace) {
            String indentation = this.createIndentation(level - 1);
            return new Pair((Object)indentation, (Object)(offset + indentation.length() + 1));
        }
        boolean hasOnlyLeadingWhitespace = this.hasLineOnlyLeadingWhitespace(source, offset - 1);
        if (isNextCharClosingCurlyBrace && hasOnlyLeadingWhitespace) {
            String indentation = this.createIndentation(level - 1);
            return new Pair((Object)indentation, (Object)(offset + indentation.length() + 1));
        }
        String indentation = this.createIndentation(level);
        int adjustedOffset = offset + indentation.length() + 1;
        StringBuilder indentationPlusLinebreak = new StringBuilder(indentation);
        indentationPlusLinebreak.append(StringUtility.DEFAULT_LINE_SEPARATOR);
        indentationPlusLinebreak.append(this.createIndentation(level - 1));
        return new Pair((Object)indentationPlusLinebreak.toString(), (Object)adjustedOffset);
    }

    private boolean hasLineOnlyLeadingWhitespace(String text, int offset) {
        int i = offset;
        while (i >= 0) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return false;
            }
            if (text.charAt(i) == '\n') {
                return true;
            }
            --i;
        }
        return true;
    }

    protected final int moveLexerToOffset(ILexer lexer, int offset) {
        assert (lexer != null) : "Parameter 'lexer' of method 'moveLexerToOffset' must not be null";
        assert (offset >= 0) : "Parameter 'offset' of method 'moveLexerToOffset' must not be negative";
        int level = 0;
        try {
            int token = lexer.nextToken();
            while (token != -1) {
                if (token == (Integer)this.m_l_r_braces.getFirst()) {
                    ++level;
                } else if (token == (Integer)this.m_l_r_braces.getSecond()) {
                    --level;
                }
                if (lexer.getPosition().getOffset() == offset) {
                    return level;
                }
                if (lexer.getPosition().getOffset() + lexer.getLexeme().length() >= offset) {
                    return level;
                }
                token = lexer.nextToken();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return level;
    }

    @Override
    public final String getTabString() {
        if (this.m_options.useTabs()) {
            return "\t";
        }
        return StringUtility.concat((String)" ", (int)this.m_options.getTabSize());
    }

    @Override
    public final int computeOffset(int offset, String text, String formattedText) {
        assert (text != null) : "Parameter 'text' of method 'computeOffset' must not be null";
        assert (formattedText != null) : "Parameter 'formattedText' of method 'computeOffset' must not be null";
        assert (offset >= 0) : "Parameter 'offset' of method 'computeOffset' must be >= 0";
        if (text.isEmpty() || formattedText.isEmpty()) {
            return 0;
        }
        if (offset >= text.length()) {
            return formattedText.length();
        }
        int formattedOffset = 0;
        int index = 0;
        while (index < offset) {
            if (text.charAt(index) == formattedText.charAt(formattedOffset)) {
                ++index;
                ++formattedOffset;
                continue;
            }
            if (StringUtility.isWhitespace((char)text.charAt(index))) {
                while (index < text.length() && StringUtility.isWhitespace((char)text.charAt(index))) {
                    ++index;
                }
                while (formattedOffset < formattedText.length() && StringUtility.isWhitespace((char)formattedText.charAt(formattedOffset))) {
                    ++formattedOffset;
                }
                continue;
            }
            if (StringUtility.isWhitespace((char)formattedText.charAt(formattedOffset))) {
                while (formattedOffset < formattedText.length() && StringUtility.isWhitespace((char)formattedText.charAt(formattedOffset))) {
                    ++formattedOffset;
                }
                continue;
            }
            if (text.charAt(index) == ';') {
                ++index;
                continue;
            }
            LOGGER.warn("Cannot compute offset at offset {} and formatted offset {}", (Object)index, (Object)formattedOffset);
            break;
        }
        return formattedOffset;
    }

    @Override
    public final String removeBlockIndentation(List<String> lines) {
        assert (lines != null && !lines.isEmpty()) : "Parameter 'lines' of method 'removeBlockIndentation' must not be empty";
        StringBuilder contentToReplace = new StringBuilder();
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            contentToReplace.append(this.removeBlockIndentation(line));
            ++i;
        }
        return contentToReplace.toString();
    }

    private String removeBlockIndentation(String line) {
        if (line.startsWith("\t")) {
            return line.substring(1);
        }
        int i = this.m_options.getTabSize();
        while (i > 0) {
            if (line.startsWith(" ")) {
                line = line.substring(1);
            }
            --i;
        }
        return line;
    }

    protected void addBlankIfNecessary(StringBuffer buffer) {
        assert (buffer != null) : "Parameter 'buffer' of method 'addBlankIfNecessary' must not be null";
        if (buffer.length() >= 1 && buffer.charAt(buffer.length() - 1) != ' ') {
            buffer.append(" ");
        }
    }

    protected void clearWhitespace(StringBuffer buffer) {
        assert (buffer != null) : "Parameter 'buffer' of method 'clearWhitespace' must not be null";
        if (buffer.length() >= 2 && buffer.charAt(buffer.length() - 1) == ' ' && buffer.charAt(buffer.length() - 2) != ' ') {
            buffer.setLength(buffer.length() - 1);
        }
    }

    protected void clearLine(StringBuffer buffer) {
        assert (buffer != null) : "Parameter 'buffer' of method 'removeIndentation' must not be null";
        int lastIndexOfLineBreak = buffer.lastIndexOf(this.m_options.getLineBreak());
        if (lastIndexOfLineBreak != -1) {
            buffer.setLength(lastIndexOfLineBreak + this.m_options.getLineBreak().length());
        }
    }

    protected final String createIndentation(int level) {
        if (level <= 0) {
            return "";
        }
        if (this.m_options.useTabs()) {
            return StringUtility.concat((String)"\t", (int)level);
        }
        return StringUtility.concat((String)" ", (int)(level * this.m_options.getTabSize()));
    }
}

