/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.coupling;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.AbstractCohesionAndCouplingMetricsAdapter;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IConnectedComponentComputerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class CohesionAndCouplingMetricsModule
extends AbstractCohesionAndCouplingMetricsAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.COHESION_AND_COUPLING_METRICS_MODULE;
    private final Map<Language, IMetricDescriptor> m_languageToRelationalCohesionModule = new THashMap();
    private final IMetricDescriptor m_logicalCohesionModule;
    private final IMetricDescriptor m_logicalCouplingModule;

    public CohesionAndCouplingMetricsModule(IAnalyzerController controller) {
        super(controller, ID);
        Predicate<NamedElement> moduleFilter = e -> e instanceof LogicalModuleProgrammingElement;
        Predicate<NamedElement> moduleNamesapceFilter = e -> e instanceof LogicalModuleNamespace;
        Predicate<NamedElement> typeFilter = e -> ((LogicalProgrammingElement)e).getPrimaryProgrammingElement() instanceof IType && !(e.getParent() instanceof LogicalProgrammingElement);
        Predicate<NamedElement> typeFilterModule = moduleFilter.and(typeFilter);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_logicalCohesionModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LOGICAL_COHESION_MODULE, CoreMetricLevel.LOGICAL_PROGRAMMING_ELEMENT, typeFilterModule);
        this.m_logicalCouplingModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LOGICAL_COUPLING_MODULE, CoreMetricLevel.LOGICAL_PROGRAMMING_ELEMENT, typeFilterModule);
        for (Language nextUsedLanguage : controller.getSoftwareSystem().getUsedLanguages()) {
            IMetricAwareLanguageProvider nextLanguageProvider = controller.getLanguageProvider(nextUsedLanguage);
            if (nextLanguageProvider.getNamespaceMetricLevel() == null) continue;
            this.m_languageToRelationalCohesionModule.put(nextUsedLanguage, this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_RELATIONAL_COHESION_MODULE, nextLanguageProvider.getNamespaceMetricLevel(), moduleNamesapceFilter, nextUsedLanguage));
        }
    }

    @Override
    public void languageAdded(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageAdded' must not be null";
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        Language language = languageProvider.getLanguage();
        if (languageProvider.getNamespaceMetricLevel() != null) {
            Predicate<NamedElement> moduleNamesapceFilter = e -> e instanceof LogicalModuleNamespace;
            this.m_languageToRelationalCohesionModule.put(language, this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_RELATIONAL_COHESION_MODULE, languageProvider.getNamespaceMetricLevel(), moduleNamesapceFilter, language));
        }
    }

    @Override
    public void languageRemoved(IMetricAwareLanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageRemoved' must not be null";
        Language language = languageProvider.getLanguage();
        IMetricDescriptor removedModuleScope = this.m_languageToRelationalCohesionModule.remove(language);
        assert (removedModuleScope != null) : "'removedModuleScope' of method 'languageRemoved' must not be null";
        this.remove(Collections.singletonList(removedModuleScope));
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        CohesionAndCouplingMetricsModuleJob job = new CohesionAndCouplingMetricsModuleJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private final class CohesionAndCouplingMetricsModuleJob
    extends AbstractCohesionAndCouplingMetricsAdapter.CohesionAndCouplingMetricsJob
    implements IConnectedComponentComputerAdapter {
        private final Map<Language, ValueList> m_languageToRelationalCohesionValueListModule;
        private final ValueList m_valueListLogicalCohesionModule;
        private final ValueList m_valueListLogicalCouplingModule;

        protected CohesionAndCouplingMetricsModuleJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(CohesionAndCouplingMetricsModule.this, group, result, controller);
            this.m_languageToRelationalCohesionValueListModule = new THashMap();
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            this.m_valueListLogicalCohesionModule = CohesionAndCouplingMetricsModule.this.createValueList(result, CohesionAndCouplingMetricsModule.this.m_logicalCohesionModule, softwareSystem);
            this.m_valueListLogicalCouplingModule = CohesionAndCouplingMetricsModule.this.createValueList(result, CohesionAndCouplingMetricsModule.this.m_logicalCouplingModule, softwareSystem);
            for (Map.Entry<Language, IMetricDescriptor> nextEntry : CohesionAndCouplingMetricsModule.this.m_languageToRelationalCohesionModule.entrySet()) {
                this.m_languageToRelationalCohesionValueListModule.put(nextEntry.getKey(), CohesionAndCouplingMetricsModule.this.createValueList(result, nextEntry.getValue(), softwareSystem));
            }
        }

        @Override
        public void components(Set<List<INode<?>>> components) {
            assert (components != null) : "Parameter 'components' of method 'components' must not be null";
        }

        @Override
        public void internalRun() {
            IWorkerContext workerContext = this.getWorkerContext();
            workerContext.setNumberOfSteps(2);
            workerContext.beginSubTask("Collect logical module namespaces");
            ArrayList<LogicalNamespace> logicalModuleNamespaces = new ArrayList<LogicalNamespace>();
            for (ModuleBasedLogicalNamespaceRoot nextModule : this.getSoftwareSystem().getUniqueExistingChild(LogicalModuleNamespaces.class).getChildren(ModuleBasedLogicalNamespaceRoot.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                logicalModuleNamespaces.addAll(nextModule.getNonPartLogicalNamespaces());
            }
            workerContext.endSubTask();
            workerContext.beginSubTask("Calculate namspace (module based) cohesion and coupling");
            if (!logicalModuleNamespaces.isEmpty()) {
                this.calculateLogicalCohesionAndCoupling(logicalModuleNamespaces, this.m_valueListLogicalCohesionModule, this.m_valueListLogicalCouplingModule, this.m_languageToRelationalCohesionValueListModule, workerContext);
            }
            workerContext.endSubTask();
        }
    }
}

