/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controllerinterface.common.ILicenseProvider;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemProviderCreator;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class SoftwareSystemControllerCreator
implements ISoftwareSystemProviderCreator {
    abstract ISoftwareSystemProvider createController(ILicenseProvider var1, Set<LanguageProvider> var2, ScriptOutputStreamProvider var3, AnalyzerExecutionLevel var4);

    @Override
    public final ISoftwareSystemProvider create(ILicenseProvider licenseProvider, List<ILanguageProvider> languageProviders, ScriptOutputStreamProvider outputProvider, AnalyzerExecutionLevel level) {
        assert (licenseProvider != null) : "Parameter 'licenseProvider' of method 'create' must not be null";
        assert (languageProviders != null) : "Parameter 'languageProviders' of method 'createSoftwareSystemController' must not be null";
        assert (outputProvider != null) : "Parameter 'outputProvider' of method 'create' must not be null";
        assert (level != null) : "Parameter 'level' of method 'create' must not be null";
        HashSet<LanguageProvider> castedLanguageProviders = new HashSet<LanguageProvider>(languageProviders.size());
        for (ILanguageProvider nextLanguageProvider : languageProviders) {
            assert (nextLanguageProvider instanceof LanguageProvider) : "Not a language provider: " + String.valueOf(nextLanguageProvider.getClass());
            boolean success = castedLanguageProviders.add((LanguageProvider)nextLanguageProvider);
            assert (success) : "Already added: " + String.valueOf(nextLanguageProvider.getLanguage());
        }
        return this.createController(licenseProvider, castedLanguageProviders, outputProvider, level);
    }
}

