/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IAuthorsExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.RegexValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.author.SourceFilesToAuthorsInfo;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemSettingsDirectory;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthorsExtension
extends Extension
implements IAuthorsExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorsExtension.class);
    private static final String AUTHORS_KEY = "$Authors$";
    private final Map<String, String> m_aliasMap = new THashMap();
    private final Set<String> m_authors = new THashSet();
    private final SoftwareSystem m_softwareSystem;
    private boolean m_isDirty;

    public AuthorsExtension(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'AuthorsExtension' must not be null";
        this.m_softwareSystem = softwareSystem;
        Properties props = new Properties();
        TFile in = this.getDeveloperPropertiesFile(new OperationResult("Delete empty directory"), true);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new TFileInputStream((File)in)));){
                props.load(reader);
                String authorsList = props.getProperty(AUTHORS_KEY);
                if (authorsList != null) {
                    String[] stringArray = authorsList.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String nextAuthor = stringArray[n2];
                        if (nextAuthor != null && !nextAuthor.isEmpty()) {
                            this.m_authors.add(nextAuthor);
                        }
                        ++n2;
                    }
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        if (entry.getKey().equals(AUTHORS_KEY)) continue;
                        this.m_aliasMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            LOGGER.error("Problem reading from " + in.getAbsolutePath(), (Throwable)e);
        }
    }

    private TFile getDeveloperPropertiesFile(OperationResult result, boolean removeEmptyDirectory) {
        String[] files;
        assert (result != null) : "Parameter 'result' of method 'getDeveloperPropertiesFile' must not be null";
        SoftwareSystemSettingsDirectory settingsDirectory = this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory();
        TFile settingsDir = settingsDirectory.getFile();
        if (removeEmptyDirectory && settingsDir.exists() && (files = settingsDir.list()) != null && files.length == 0) {
            try {
                settingsDir.rm();
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)ex);
            }
        }
        return new TFile((File)settingsDir, "Developers.properties");
    }

    @Override
    public synchronized void addAuthorIfNeeded(String author) {
        assert (author != null && author.length() > 0) : "Parameter 'author' of method 'addAuthorIfNeeded' must not be empty";
        if (this.m_authors.contains(author)) {
            return;
        }
        if (this.m_aliasMap.get(author) != null) {
            return;
        }
        this.m_authors.add(author);
        this.writeProperties();
    }

    @Override
    public synchronized String getAuthorNameFromPotentialAlias(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getAuthorNameFromPotentialAlias' must not be empty";
        if (this.m_authors.contains(name)) {
            return name;
        }
        String result = this.m_aliasMap.get(name);
        if (result == null) {
            this.m_authors.add(name);
            result = name;
            this.m_isDirty = true;
        }
        return result;
    }

    @Override
    public synchronized Collection<String> getAuthors() {
        ArrayList<String> authors = new ArrayList<String>(this.m_authors);
        authors.sort((s1, s2) -> s1.compareTo((String)s2));
        return authors;
    }

    @Override
    public synchronized Map<String, String> getAliasMap() {
        return Collections.unmodifiableMap(this.m_aliasMap);
    }

    private OperationResult writeProperties() {
        OperationResult result = new OperationResult("Write developer info");
        SoftwareSystemSettingsDirectory settingsDirectory = this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemSettingsDirectory();
        settingsDirectory.enforceExistence(result);
        if (result.isFailure()) {
            return result;
        }
        TFile out = this.getDeveloperPropertiesFile(result, false);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter((File)out));){
                Properties props = new Properties();
                props.put(AUTHORS_KEY, this.m_authors.stream().collect(Collectors.joining(",")));
                props.putAll(this.m_aliasMap);
                props.store(writer, "Manages developer names and aliases");
                this.m_isDirty = false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Problem writing to " + out.getAbsolutePath(), (Throwable)e);
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e);
            this.m_isDirty = true;
        }
        return result;
    }

    @Override
    public synchronized void updateAuthorsAndAliases(OperationResult result, Map<String, String> aliases, Collection<String> authors) {
        assert (aliases != null) : "Parameter 'newMap' of method 'updateAliasMap' must not be null";
        assert (authors != null) : "Parameter 'authors' of method 'updateAuthorsAndAliases' must not be null";
        HashSet<AnalyzerGroup> group = new HashSet<AnalyzerGroup>();
        group.add(AnalyzerGroup.SCM);
        IAnalyzerExecutionController analyzerExtension = this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class);
        Set<AnalyzerGroup> toRestart = analyzerExtension.cancelAndResetAnalyzerGroups(group, ResetMode.ALL);
        this.m_aliasMap.clear();
        this.m_aliasMap.putAll(aliases);
        this.m_authors.clear();
        this.m_authors.addAll(authors);
        result.addMessagesFrom(this.writeProperties());
        analyzerExtension.runAnalyzerGroups(toRestart);
    }

    @Override
    public synchronized void scmDataAnalysisFinished() {
        if (this.m_isDirty) {
            this.writeProperties();
        }
    }

    @Override
    public ITextValidator getAuthorNameValidator(final List<String> existingNames) {
        assert (existingNames != null) : "Parameter 'existingNames' of method 'getAuthorNameValidator' must not be null";
        return new RegexValidator("(\\p{Alpha}|\\p{Digit}|\\-|\\.|_)+( (\\p{Alpha}|\\p{Digit}|\\-|_|\\.)+)*"){

            @Override
            public ValidationResult isValid(String initialInput, String newInput) {
                ValidationResult result = super.isValid(initialInput, newInput);
                if (!result.isFailure() && existingNames.contains(newInput)) {
                    result.addError("Author is already in use.");
                }
                return result;
            }
        };
    }

    @Override
    public ITextValidator getAliasNameValidator(final List<String> existingNames) {
        assert (existingNames != null) : "Parameter 'existingNames' of method 'getAliasNameValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String initialInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
                if (newInput == null) {
                    result.addError("Must not be null.");
                } else if (newInput.isEmpty()) {
                    result.addError("Must not be empty.");
                } else if (existingNames.contains(newInput)) {
                    result.addError("Alias is already in use.");
                } else if (newInput.startsWith(" ") || newInput.endsWith(" ")) {
                    result.addError("Alias must not have leading/trailing spaces.");
                }
                return result;
            }
        };
    }

    @Override
    public SourceFilesToAuthorsInfo getSourceFilesToAuthors() {
        IAnalyzerController analyzerExtension = this.m_softwareSystem.getExtension(IAnalyzerController.class);
        AnalyzerResult result = analyzerExtension.getResultFor(CoreAnalyzerId.SCM_METRICS);
        if (result != null && result.getState() == AnalyzerState.FINISHED) {
            return result.getUniqueChild(SourceFilesToAuthorsInfo.class);
        }
        return null;
    }
}

