/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ArchitecturalViewOperationExtension;
import com.hello2morrow.sonargraph.core.controller.system.ArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.controller.system.ArchitectureExtension;
import com.hello2morrow.sonargraph.core.controller.system.IArchitecturalFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.UpdateInfo;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.base.ModelModificationInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitectureFileGenerator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.CreateArtifactFromElementsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.CreateArtifactsForElementsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.DeleteElementsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.EditArtifactResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.EditArtifactsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FilterHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ITransferHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.LoadedRepresentationInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.MetricsHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.OperationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RefactoringHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StateHandler;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.SoftwareSystemDefinitionFileReadError;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewLoadedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.event.ContextsModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactNameValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFinding;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewState;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeConnection;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateAllowedArtifactConnectionOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactFromElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactsForElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateElementOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateFindingOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteArchitecturalViewFileInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteDependenciesOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.EditArtifactOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.EditArtifactsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewMetrics;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.HideElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.MovableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.OperationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveElementCreationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RenameElementInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RenameElementOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferArchitectureExecutionInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferExecutionInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferRefactoringsExecutionInfo;
import com.hello2morrow.sonargraph.core.model.path.ArchitecturalViewsDirectory;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class ArchitecturalViewExtension
extends ArchitecturalViewProvider
implements IArchitecturalViewExtension,
IArchitecturalFileProvider,
ISoftwareSystemLifecycleListener,
IModifiableFileProvider,
IModifiableFileDeltaKey {
    public ArchitecturalViewExtension(LanguageProviderAccessor accessor, Installation installation, SoftwareSystem softwareSystem, IElementResolver resolver, IFinishModelProcessor finishModelProcessor, boolean enabled) {
        super(accessor, installation, softwareSystem, resolver, finishModelProcessor, enabled);
        if (this.isEnabled()) {
            this.getFinishModelProcessor().addListener(this);
        }
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'prepareRefresh' must not be null";
        if (this.isEnabled()) {
            this.getArchitecturalViewsDirectory().checkExistence();
            deltaDetector.detect(new ModifiableFileDeltaDetector.SingleFileTypeProviderAdapter(this, this.getArchitecturalViewsDirectory(), CoreFileType.ARCHITECTURAL_VIEW, ArchitecturalViewFile.class.getSimpleName(), false));
            if (!onSystemOpen) {
                deltaDetector.getDelta().visit(new ModifiableFileDelta.IVisitor(){

                    @Override
                    public IModifiableFileDeltaKey getKey() {
                        return ArchitecturalViewExtension.this;
                    }
                }, false);
            }
        }
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        if (this.isEnabled()) {
            boolean successSoFar = result.isSuccess();
            delta.visit(new ModifiableFileDelta.IVisitor(){

                @Override
                public IModifiableFileDeltaKey getKey() {
                    return ArchitecturalViewExtension.this;
                }

                @Override
                public void visitModified(IModifiableFile modified) {
                    if (!($assertionsDisabled || modified != null && modified instanceof ArchitecturalViewFile)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                    }
                    ArchitecturalViewFile file = (ArchitecturalViewFile)modified;
                    file.removeIssues(CoreIssueId.SOFTWARE_SYSTEM_DEFINITION_FILE_READ_ERROR);
                    file.removeNonInheritedOperations();
                    OperationResult loadResult = ArchitecturalViewExtension.this.getPersistence().load(modified.getFile(), file);
                    if (loadResult.isFailure()) {
                        file.addIssue(new SoftwareSystemDefinitionFileReadError(file, loadResult.toString()));
                    }
                    result.addMessagesFrom(loadResult);
                    file.reloaded(modified.getFile().lastModified(), false);
                }

                @Override
                public void visitDeleted(IModifiableFile deleted) {
                    if (!($assertionsDisabled || deleted != null && deleted instanceof ArchitecturalViewFile)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                    }
                    ArchitecturalViewFile file = (ArchitecturalViewFile)deleted;
                    if (ArchitecturalViewExtension.this.hasBeenLoaded(file)) {
                        ArchitecturalViewExtension.this.performUnload(file);
                        EventManager.getInstance().dispatch((Object)this, (Event)new ArchitecturalViewUnloadedEvent(ArchitecturalViewExtension.this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), file));
                        EventManager.getInstance().dispatch((Object)this, (Event)new ContextsModifiedEvent(ArchitecturalViewExtension.this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class)));
                    }
                    file.remove();
                }

                @Override
                public void visitAdded(ModifiableFileCandidate added) {
                    if (!$assertionsDisabled && added == null) {
                        throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                    }
                    TFile file = added.getFile();
                    String name = file.getName();
                    SoftwareSystem softwareSystem = ArchitecturalViewExtension.this.getSoftwareSystem();
                    ArchitecturalViewsDirectory views = ArchitecturalViewExtension.this.getArchitecturalViewsDirectory();
                    ArchitecturalViewFile architecturalViewFile = new ArchitecturalViewFile((NamedElement)views, new TFile((File)views.getFile(), name), softwareSystem.getUniqueExistingChild(Files.class));
                    views.addChild(architecturalViewFile);
                    OperationResult loadResult = ArchitecturalViewExtension.this.getPersistence().load(file, architecturalViewFile);
                    if (loadResult.isFailure()) {
                        architecturalViewFile.addIssue(new SoftwareSystemDefinitionFileReadError(architecturalViewFile, loadResult.toString()));
                    }
                    result.addMessagesFrom(loadResult);
                }
            }, true);
            this.filesModified(workerContext, modifications == null);
            if (successSoFar) {
                result.setIsSuccess(successSoFar);
            }
        }
    }

    @Override
    public OperationResultWithOutcome<ArchitecturalViewFile> create(IWorkerContext workerContext, String name, String description, ExplorationViewStructureMode mode) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'create' must not be null";
        ValidationResult isValid = this.getArchitecturalViewNameValidator().isValid(null, name);
        assert (isValid.isSuccess()) : "Name '" + name + "' is not valid: " + String.valueOf(isValid);
        assert (description != null) : "Parameter 'description' of method 'create' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'create' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create architectural view '" + name + "'");
        this.checkOutOfSync((OperationResult)result);
        if (result.isSuccess()) {
            ArchitecturalViewFile newFile = this.createFile(name, description, mode, null, (OperationResult)result);
            this.fileContentModified(newFile);
            result.setOutcome((Object)newFile);
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)result);
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<ArchitecturalViewFile> create(IWorkerContext workerContext, String name, String description, ArchitecturalViewFile basedOn) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'create' must not be null";
        ValidationResult isValid = this.getArchitecturalViewNameValidator().isValid(null, name);
        assert (isValid.isSuccess()) : "Name '" + name + "' is not valid: " + String.valueOf(isValid);
        assert (description != null) : "Parameter 'description' of method 'create' must not be null";
        assert (basedOn != null) : "Parameter 'basedOn' of method 'create' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create architectural view '" + name + "' based on '" + basedOn.getIdentifyingPath() + "'");
        this.checkOutOfSync((OperationResult)result);
        if (result.isSuccess()) {
            ArchitecturalViewFile newFile = this.createFile(name, description, basedOn.getStructureMode(), basedOn, (OperationResult)result);
            this.fileContentModified(newFile);
            result.setOutcome((Object)newFile);
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)result);
        }
        return result;
    }

    @Override
    public OperationResult delete(IWorkerContext workerContext, DeleteArchitecturalViewFileInfo info) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'delete' must not be null";
        assert (info != null) : "Parameter 'info' of method 'delete' must not be null";
        assert (info.getNumberOfAllFiles() > 0) : "No files to delete";
        OperationResult result = new OperationResult("Delete " + info.getNumberOfAllFiles() + " architectural view(s)");
        this.checkOutOfSync(result);
        if (result.isSuccess()) {
            ArrayList<ArchitecturalViewFile> allToDelete = new ArrayList<ArchitecturalViewFile>(info.getAllFiles());
            Collections.sort(allToDelete, new NamedElementUtility.DepthComparator(false));
            boolean contextModified = false;
            for (ArchitecturalViewFile nextFile : allToDelete) {
                if (this.hasBeenLoaded(nextFile)) {
                    this.performUnload(nextFile);
                    EventManager.getInstance().dispatch((Object)this, (Event)new ArchitecturalViewUnloadedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), nextFile));
                    contextModified = true;
                }
                SoftwareSystemFilesDirectory.removeFile(nextFile.getFile(), false, result);
                nextFile.remove();
            }
            if (contextModified) {
                EventManager.getInstance().dispatch((Object)this, (Event)new ContextsModifiedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class)));
            }
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        }
        return result;
    }

    @Override
    public OperationResult load(IWorkerContext workerContext, ArchitecturalViewFile file, PresentationMode presentationMode) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'load' must not be null";
        assert (file != null) : "Parameter 'file' of method 'load' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'load' must not be null";
        OperationResult result = new OperationResult("Load architectural view file '" + file.getIdentifyingPath() + "'");
        this.checkOutOfSync(result);
        if (result.isSuccess() && this.load(workerContext, file, presentationMode, null, null, result)) {
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
            EventManager.getInstance().dispatch((Object)this, (Event)new ArchitecturalViewLoadedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), file));
        }
        return result;
    }

    @Override
    public OperationResult loadOnDemand(IWorkerContext workerContext, ExplorationViewOnDemand onDemand, PresentationMode presentationMode, ExplorationViewFocusProperties focusProperties) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'loadOnDemand' must not be null";
        assert (onDemand != null) : "Parameter 'onDemand' of method 'loadOnDemand' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'loadOnDemand' must not be null";
        OperationResult result = new OperationResult("Load architectural view on demand");
        if (this.load(workerContext, onDemand, presentationMode, null, focusProperties, result)) {
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
            EventManager.getInstance().dispatch((Object)this, (Event)new ArchitecturalViewLoadedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), onDemand));
        }
        return result;
    }

    @Override
    public void aboutToModifyParserModel(IWorkerContext workerContext, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToModifyParserModel' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToModifyParserModel' must not be null";
        for (ArchitecturalViewFile nextFile : this.getAvailableArchitecturalViewFiles()) {
            if (!this.hasBeenLoaded(nextFile)) continue;
            FocusHandler.aboutToModifyParserModel(this.getResolver(), nextFile.getUniqueExistingChild(ExplorationViewRepresentation.class));
        }
        for (ExplorationViewOnDemand next : this.getSoftwareSystem().getUniqueExistingChild(Representations.class).getChildren(ExplorationViewOnDemand.class)) {
            if (!this.hasBeenLoaded(next)) continue;
            FocusHandler.aboutToModifyParserModel(this.getResolver(), next.getUniqueExistingChild(ExplorationViewRepresentation.class));
        }
    }

    @Override
    public void modelModificationFinished(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<ModelModificationInfo.ModelModification> modelModifications, List<SoftwareSystemEvent> eventsToDispatch, List<IModifiableFile> restoredFiles, INavigationState navigationState) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'modelModificationFinished' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'modelModificationFinished' must not be null";
        assert (modelModifications != null) : "Parameter 'modelModifications' of method 'modelModificationFinished' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'modelModificationFinished' must not be null";
        ArchitecturalViewFile restored = restoredFiles != null && !restoredFiles.isEmpty() ? this.getRestoredFile(restoredFiles) : null;
        Set<UpdateInfo> updateInfo = this.getUpdateInfo(modelModifications);
        if (!updateInfo.isEmpty()) {
            this.processModified(workerContext, softwareSystem, this.getAvailableArchitecturalViewFiles(updateInfo, restored), false, eventsToDispatch);
            this.processModifiedOnDemand(workerContext, softwareSystem, this.getAvailableOnDemand(updateInfo), eventsToDispatch);
        }
        if (restored != null) {
            boolean contextsModified = false;
            if (this.hasBeenLoaded(restored)) {
                ExplorationViewRepresentation representation = restored.getUniqueExistingChild(ExplorationViewRepresentation.class);
                assert (!representation.isInTransfer()) : "In transfer";
                if (!restored.getStructureMode().equals((Object)representation.getStructureMode())) {
                    ArchitecturalViewState state = StateHandler.createState(representation);
                    ExplorationViewFocus focus = !representation.getFocus().isEmpty() ? representation.getFocus().copy() : null;
                    this.performUnload(restored);
                    workerContext.working("Updating architectural view '" + restored.getIdentifyingPath() + "'", true);
                    if (this.load((IWorkerContext)DefaultWorkerContext.INSTANCE, restored, representation.getPresentationMode(), focus, state, null)) {
                        eventsToDispatch.add(new ArchitecturalViewModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), restored, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.UNDO_REDO)));
                    } else {
                        eventsToDispatch.add(new ArchitecturalViewUnloadedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), restored));
                    }
                    contextsModified = true;
                } else {
                    this.getSoftwareSystem().getExtension(ArchitecturalViewOperationExtension.class).reApplyOperations(workerContext, restored);
                }
            } else {
                eventsToDispatch.add(new ArchitecturalViewModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), restored, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.UNDO_REDO)));
                contextsModified = true;
            }
            if (contextsModified) {
                eventsToDispatch.add(new ContextsModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzerFinished(SoftwareSystem softwareSystem, IAnalyzerId analyzerId, boolean issuesModified, boolean metricValuesAdded, boolean metricDescriptorAdded, List<SoftwareSystemEvent> eventsToDispatch) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'analyzerFinished' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'analyzerFinished' must not be null";
        if (CoreAnalyzerId.ARCHITECTURE_CHECK.equals(analyzerId)) {
            ISoftwareSystemProvider systemProvider = softwareSystem.getExtension(ISoftwareSystemProvider.class);
            boolean contextsModified = false;
            for (ExplorationViewOnDemand nextOnDemand : softwareSystem.getUniqueExistingChild(Representations.class).getChildren(ExplorationViewOnDemand.class)) {
                ExplorationViewRepresentation nextRepresentation;
                ExplorationViewRepresentation explorationViewRepresentation = nextRepresentation = nextOnDemand.getUniqueExistingChild(ExplorationViewRepresentation.class);
                synchronized (explorationViewRepresentation) {
                    RepresentationHandler.updateAggregatedDependencies(nextRepresentation);
                    eventsToDispatch.add(new ArchitecturalViewModifiedEvent(systemProvider, nextOnDemand, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.DEPENDENCIES)));
                    contextsModified = true;
                }
            }
            if (contextsModified) {
                eventsToDispatch.add(new ContextsModifiedEvent(systemProvider));
            }
        }
    }

    @Override
    public void released(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'released' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'released' must not be null";
        boolean contextModified = false;
        for (ArchitecturalViewFile nextFile : this.getAvailableArchitecturalViewFiles()) {
            if (!this.hasBeenLoaded(nextFile)) continue;
            this.performUnload(nextFile);
            eventsToDispatch.add(new ArchitecturalViewUnloadedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), nextFile));
            contextModified = true;
        }
        for (ExplorationViewOnDemand nextOnDemand : softwareSystem.getUniqueExistingChild(Representations.class).getChildren(ExplorationViewOnDemand.class)) {
            if (!this.hasBeenLoaded(nextOnDemand)) continue;
            this.performUnload(nextOnDemand);
            eventsToDispatch.add(new ArchitecturalViewUnloadedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), nextOnDemand));
            contextModified = true;
        }
        if (contextModified) {
            eventsToDispatch.add(new ContextsModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class)));
        }
    }

    @Override
    public void cleared(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cleared' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'cleared' must not be null";
        boolean contextModified = false;
        for (ArchitecturalViewFile nextFile : this.getAvailableArchitecturalViewFiles()) {
            if (!this.hasBeenLoaded(nextFile)) continue;
            this.performUnload(nextFile);
            eventsToDispatch.add(new ArchitecturalViewUnloadedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), nextFile));
            contextModified = true;
        }
        for (ExplorationViewOnDemand nextOnDemand : softwareSystem.getUniqueExistingChild(Representations.class).getChildren(ExplorationViewOnDemand.class)) {
            if (!this.hasBeenLoaded(nextOnDemand)) continue;
            this.performUnload(nextOnDemand);
            eventsToDispatch.add(new ArchitecturalViewUnloadedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class), nextOnDemand));
            contextModified = true;
        }
        if (contextModified) {
            eventsToDispatch.add(new ContextsModifiedEvent(softwareSystem.getExtension(ISoftwareSystemProvider.class)));
        }
    }

    @Override
    public OperationResult createArtifact(IWorkerContext workerContext, AssignableTargetInfo targetInfo, String shortName, ArtifactProperties properties, ArtifactNodeFilter filter) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createArtifact' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'createArtifact' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'createArtifact' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'createArtifact' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'createArtifact' must not be null";
        assert (this.isFilterValid(filter) == null) : "Filter not valid: " + String.valueOf(filter);
        assert (this.getArtifactNameValidator(targetInfo, null).isValid(null, shortName).isSuccess()) : "Not a valid name: " + shortName;
        OperationResult result = new OperationResult("Create artifact");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(targetInfo.getTarget().getArchitecturalViewElement());
        ArtifactNode artifact = OperationHandler.opCreateArtifact(loadedInfo.getPresentationMode(), targetInfo.getTarget(), targetInfo.getRelativeIndex(), shortName, properties, filter, loadedInfo.getRepresentation());
        CreateArtifactOperation op = new CreateArtifactOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), targetInfo.getTarget().getArchitecturalViewElement().getRelativePath(), targetInfo.getRelativeIndex(), properties, shortName);
        FilterHandler.finishFilterOperationCreation(op, artifact);
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION, artifact));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult createArtifactFromElements(IWorkerContext workerContext, AssignableTargetInfo targetInfo, String shortName, ArtifactProperties properties, List<ArchitecturalViewElement> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createArtifactFromElements' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'createArtifactFromElements' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'createArtifactFromElements' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'createArtifactFromElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'createArtifactFromElements' must not be empty";
        assert (this.isCreateArtifactFromElementsPossible(elements).isAvailable()) : "Creation not possible";
        ArchitecturalViewArtifactNameValidator validator = this.getArtifactFromElementsNameValidator(targetInfo, elements);
        assert (validator.isValid(null, shortName).isSuccess()) : "Not a valid artifact short name: " + shortName;
        OperationResult result = new OperationResult("Create artifact from elements");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(targetInfo.getTarget().getArchitecturalViewElement());
        CreateArtifactFromElementsResult creationResult = OperationHandler.opCreateArtifactFromElements(loadedInfo.getPresentationMode(), targetInfo.getTarget(), targetInfo.getRelativeIndex(), shortName, properties, elements, loadedInfo.getRepresentation());
        CreateArtifactFromElementsOperation op = new CreateArtifactFromElementsOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), targetInfo.getTarget().getArchitecturalViewElement().getRelativePath(), targetInfo.getRelativeIndex(), properties, shortName, creationResult.getRelativePaths());
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION, creationResult.getCreatedArtifact()));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult createArtifactsForElements(IWorkerContext workerContext, AssignableTargetInfo targetInfo, ArtifactProperties properties, List<ArchitecturalViewElement> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createArtifactsForElements' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'createArtifactsForElements' must not be null";
        IAssignableTarget parent = targetInfo.getTarget();
        int atPos = targetInfo.getRelativeIndex();
        assert (parent instanceof ExplorationViewRepresentation || parent instanceof ArtifactNode) : "Unexpected class: " + String.valueOf(parent.getClass());
        assert (properties != null) : "Parameter 'properties' of method 'createArtifactsForElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'createArtifactsForElements' must not be empty";
        assert (this.isCreateArtifactsForElementsPossible(elements).isAvailable()) : "Creation not possible";
        OperationResult result = new OperationResult("Create artifacts from elements");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(parent.getArchitecturalViewElement());
        PresentationMode presentationMode = loadedInfo.getPresentationMode();
        CreateArtifactsForElementsResult creationResult = OperationHandler.opCreateArtifactsForElements(presentationMode, parent, atPos, properties, elements, loadedInfo.getRepresentation());
        CreateArtifactsForElementsOperation op = new CreateArtifactsForElementsOperation(loadedInfo.getOperationList(), presentationMode, parent.getArchitecturalViewElement().getRelativePath(), atPos, properties, creationResult.getRelativePaths());
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION, creationResult.getCreatedArtifact().get(0)));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult deleteElements(IWorkerContext workerContext, List<ArchitecturalViewElement> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'deleteElements' must not be empty";
        OperationResult result = new OperationResult("Delete elements");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(elements.get(0));
        DeleteElementsResult deleteElementsResult = OperationHandler.opDeleteElements(loadedInfo.getPresentationMode(), elements, loadedInfo.inLevelizationModeAll(), loadedInfo.getRepresentation());
        DeleteElementsOperation op = new DeleteElementsOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), deleteElementsResult.getRelativePaths(), deleteElementsResult.getType());
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult hideElements(IWorkerContext workerContext, List<ArchitecturalViewElement> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'hideElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'hideElements' must not be empty";
        OperationResult result = new OperationResult("Hide elements");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(elements.get(0));
        HideElementsOperation op = new HideElementsOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), OperationHandler.opHideElements(loadedInfo.getPresentationMode(), elements, loadedInfo.getRepresentation()));
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITHOUT_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult createAllowedArtifactConnection(IWorkerContext workerContext, ArtifactNodeConnection dependency) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createAllowedArtifactConnection' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'createAllowedArtifactConnection' must not be null";
        OperationResult result = new OperationResult("Create allowed artifact connection");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(dependency.getFrom());
        OperationHandler.opCreateAllowedArtifactConnection(loadedInfo.getPresentationMode(), dependency, loadedInfo.getRepresentation());
        CreateAllowedArtifactConnectionOperation op = new CreateAllowedArtifactConnectionOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), dependency.getFrom().getRelativePath(), dependency.getTo().getRelativePath());
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITHOUT_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult deleteDependencies(IWorkerContext workerContext, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteDependency' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'deleteDependencies' must not be empty";
        OperationResult result = new OperationResult("Delete dependencies");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(dependencies.get(0).getFrom());
        DeleteDependenciesOperation op = new DeleteDependenciesOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), OperationHandler.opDeleteDependencies(loadedInfo.getPresentationMode(), dependencies, loadedInfo.getRepresentation()));
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult moveElements(IWorkerContext workerContext, List<? extends ArchitecturalViewElement> elements, MovableTargetInfo targetInfo) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'moveElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'moveElements' must not be empty";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'moveElements' must not be null";
        OperationResult result = new OperationResult("Move elements");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(elements.get(0));
        PresentationMode presentationMode = loadedInfo.getRepresentation().getPresentationMode();
        MoveElementsInfo moveElementsInfo = OperationHandler.opMoveElements(presentationMode, elements, targetInfo);
        MoveElementsOperation op = new MoveElementsOperation(loadedInfo.getOperationList(), presentationMode, moveElementsInfo.getTargetInfo().getTarget().getRelativePath(), moveElementsInfo.getTargetInfo().getRelativeIndex(), moveElementsInfo.getRelativePaths(), new OperationInfo(moveElementsInfo.getInfo(), moveElementsInfo.getElementInfo(), moveElementsInfo.containsRefactoring()));
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult renameElement(IWorkerContext workerContext, ArchitecturalViewElement element, String name) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'renameElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'renameElement' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'renameElement' must not be empty";
        OperationResult result = new OperationResult("Rename element");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(element);
        String relativePath = element.getRelativePath();
        RenameElementInfo info = OperationHandler.opRenameElement(loadedInfo.getPresentationMode(), element, name, loadedInfo.getRepresentation());
        RenameElementOperation op = new RenameElementOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), relativePath, name, new OperationInfo(info.getInfo(), info.getElementInfo(), info.getContainsRefactoring()));
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult editArtifact(IWorkerContext workerContext, ArtifactNode artifact, AssignableTargetInfo targetInfo, String shortName, ArtifactProperties properties, ArtifactNodeFilter filter) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editArtifact' must not be null";
        assert (artifact != null) : "Parameter 'artifact' of method 'editArtifact' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'editArtifact' must not be null";
        assert (shortName != null) : "Parameter 'shortName' of method 'editArtifact' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'editArtifact' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'editArtifact' must not be null";
        assert (this.isFilterValid(filter) == null) : "Not a valid filter: " + String.valueOf(filter);
        assert (this.isEditArtifactsPossible(Collections.singletonList(artifact)).isAvailable()) : "Edit artifact not possible";
        if (!artifact.getShortName().equals(shortName)) assert (this.getArtifactNameValidator(targetInfo, artifact).isValid(null, shortName).isSuccess()) : "Not a valid artifact short name: " + shortName;
        OperationResult result = new OperationResult("Edit artifact");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(artifact);
        EditArtifactResult editArtifactResult = OperationHandler.opEditArtifact(loadedInfo.getPresentationMode(), artifact, targetInfo, shortName, properties, filter, loadedInfo.getRepresentation());
        assert (editArtifactResult != null) : "'editArtifactResult' of method 'editArtifact' must not be null";
        EditArtifactOperation op = new EditArtifactOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), targetInfo.getTarget().getArchitecturalViewElement().getRelativePath(), targetInfo.getRelativeIndex(), properties, editArtifactResult.getRelativePath(), shortName);
        op.setFilterOperation(editArtifactResult.getFilterOperation());
        FilterHandler.finishFilterOperationCreation(op, artifact);
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(editArtifactResult.structureModified() ? ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION : ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITHOUT_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult editArtifacts(IWorkerContext workerContext, List<ArtifactNode> artifacts, AssignableTargetInfo targetInfo, ArtifactProperties properties) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editArtifacts' must not be null";
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'editArtifacts' must not be empty";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'editArtifacts' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'editArtifacts' must not be null";
        assert (this.isEditArtifactsPossible(artifacts).isAvailable()) : "Edit artifacts not possible";
        OperationResult result = new OperationResult("Edit artifacts");
        ArchitecturalViewElement parent = targetInfo.getTarget().getArchitecturalViewElement();
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(parent);
        EditArtifactsResult editArtifactsResult = OperationHandler.opEditArtifacts(loadedInfo.getPresentationMode(), artifacts, targetInfo, properties, loadedInfo.getRepresentation());
        assert (editArtifactsResult != null) : "'editArtifactsResult' of method 'editArtifacts' must not be null: No changes";
        EditArtifactsOperation op = new EditArtifactsOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), parent.getRelativePath(), targetInfo.getRelativeIndex(), properties, editArtifactsResult.getRelativePaths());
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(editArtifactsResult.structureModified() ? ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION : ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITHOUT_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult transfer(IWorkerContext workerContext, TransferExecutionInfo executionInfo) {
        boolean transferRefactorings;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'generateArchitectureFile' must not be null";
        assert (executionInfo != null) : "Parameter 'executionInfo' of method 'transfer' must not be null";
        assert (executionInfo.isTransferPossible()) : "Transfer not possible: " + String.valueOf(executionInfo);
        ArchitecturalViewFile file = executionInfo.getFile();
        assert (this.hasBeenLoaded(file)) : "file not loaded";
        OperationResult result = new OperationResult("Transfer architecture file '" + file.getIdentifyingPath() + "'");
        IAnalyzerExecutionController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerExecutionController.class);
        Set<AnalyzerGroup> allToRestart = null;
        TransferArchitectureExecutionInfo architectureExecutionInfo = executionInfo.getArchitectureExecutionInfo();
        TransferRefactoringsExecutionInfo refactoringsExecutionInfo = executionInfo.getRefactoringsExecutionInfo();
        boolean transferArchitecture = architectureExecutionInfo != null && architectureExecutionInfo.transfer();
        boolean bl = transferRefactorings = refactoringsExecutionInfo != null && refactoringsExecutionInfo.transfer();
        assert (transferArchitecture || transferRefactorings) : "Nothing to transfer";
        if (transferRefactorings) {
            analyzerExtension.cancelAndResetAllAnalyzers(ResetMode.ALL);
        } else {
            allToRestart = analyzerExtension.cancelAndResetAnalyzerGroups(ArchitectureExtension.GROUPS, ResetMode.ALL);
        }
        ExplorationViewRepresentation representation = file.getUniqueExistingChild(ExplorationViewRepresentation.class);
        representation.setInTransfer(true);
        if (transferArchitecture) {
            workerContext.working("Create architecture file", true);
            TFile targetFile = architectureExecutionInfo.getTargetFile();
            TFile parentDirectory = targetFile.getParentFile();
            if (parentDirectory != null && !parentDirectory.exists()) {
                parentDirectory.mkdirs();
            }
            new ArchitectureFileGenerator().generate(workerContext, targetFile, file.getIdentifyingPath(), architectureExecutionInfo.getDescription(), representation, result);
            if (result.isSuccess()) {
                ArchitectureFile generated = this.getSoftwareSystem().getExtension(ArchitectureExtension.class).architectureFileGenerated(workerContext, null, targetFile, architectureExecutionInfo.addToArchitectureCheck(), result);
                result.addInfo((OperationResult.IMessageCause)ArchitecturalViewMessageCause.ARCHITECTURE_FILE_SUCCESSFULLY_GENERATED, "File '" + targetFile.getAbsolutePath() + "' written.");
                if (architectureExecutionInfo.transferIgnoreViolationResolutions()) {
                    ITransferHandler transferHandler = this.getSoftwareSystem().getExtension(ITransferHandler.class);
                    Map<ArchitecturalViewFinding, List<ParserDependency>> ignoreViolationInfo = architectureExecutionInfo.getIgnoredViolationsInfo();
                    for (Map.Entry<ArchitecturalViewFinding, List<ParserDependency>> nextEntry : ignoreViolationInfo.entrySet()) {
                        String nextDescription = nextEntry.getKey().getDescription();
                        String nextNameAndDescription = nextEntry.getKey().getName() + (String)(nextDescription.isEmpty() ? "" : " '" + nextDescription + "'");
                        transferHandler.createIgnoreViolationResolution(generated, nextNameAndDescription, nextEntry.getValue(), result);
                    }
                }
            }
        }
        ArrayList<ArchitecturalViewOperation> refactoringRelatedOperations = null;
        if (transferRefactorings) {
            if (refactoringsExecutionInfo.deleteRefactoringRelatedOperations()) {
                refactoringRelatedOperations = new ArrayList<ArchitecturalViewOperation>();
                for (ArchitecturalViewOperation nextOp : file.getOperations()) {
                    if (!nextOp.containsRefactoring()) continue;
                    refactoringRelatedOperations.add(nextOp);
                }
            }
            workerContext.working("Create refactorings", true);
            RefactoringHandler.transfer(workerContext, this.getSoftwareSystem().getExtension(ITransferHandler.class), file.getIdentifyingPath(), refactoringsExecutionInfo, representation, result);
            result.addInfo((OperationResult.IMessageCause)ArchitecturalViewMessageCause.REFACTORINGS_SUCCESSFULLY_TRANSFERRED, "Into model '" + this.getSoftwareSystem().getCurrentModel().getName() + "'.");
        }
        representation.setInTransfer(false);
        if (transferRefactorings) {
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.VIRTUAL_MODEL_MODIFIED, Modification.REFACTORINGS_MODIFIED), result);
        }
        ArrayList<SoftwareSystemEvent> eventsToDispatch = new ArrayList<SoftwareSystemEvent>();
        this.processModified(workerContext, this.getSoftwareSystem(), Collections.singletonList(file), true, eventsToDispatch);
        if (refactoringRelatedOperations != null && !refactoringRelatedOperations.isEmpty()) {
            ArrayList<ArchitecturalViewOperation> toBeDeleted = new ArrayList<ArchitecturalViewOperation>(refactoringRelatedOperations.size());
            for (ArchitecturalViewOperation nextOp : refactoringRelatedOperations) {
                if (!nextOp.hasIssues(CoreIssueId.ARCHITECTURAL_VIEW_OPERATION_NOT_APPLICABLE)) continue;
                toBeDeleted.add(nextOp);
            }
            if (!toBeDeleted.isEmpty()) {
                this.getSoftwareSystem().getExtension(ArchitecturalViewOperationExtension.class).deleteOperations(file, toBeDeleted);
            }
        }
        eventsToDispatch.forEach(e -> EventManager.getInstance().dispatch((Object)this, (Event)e));
        if (allToRestart != null) {
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.ARCHITECTURE_MODIFIED), result);
            analyzerExtension.runAnalyzerGroups(allToRestart);
        } else {
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.ARCHITECTURE_MODIFIED, Modification.REFACTORINGS_MODIFIED, Modification.VIRTUAL_MODEL_MODIFIED), result);
            analyzerExtension.runAutomatedAnalyzers(workerContext);
        }
        return result;
    }

    @Override
    public void save(ArchitecturalViewFile file, OutputStream outputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        this.getPersistence().save(file, outputStream, result);
    }

    @Override
    public void restoreFile(ArchitecturalViewFile file, InputStream inputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'load' must not be null";
        assert (inputStream != null) : "Parameter 'inputStream' of method 'load' must not be null";
        assert (result != null) : "Parameter 'result' of method 'load' must not be null";
        file.removeNonInheritedOperations();
        result.addMessagesFrom(this.getPersistence().load(inputStream, file));
    }

    @Override
    public OperationResult createElement(IWorkerContext workerContext, RecursiveElementCreationInfo creationInfo, String name) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createElement' must not be null";
        assert (creationInfo != null) : "Parameter 'creationInfo' of method 'createElement' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createElement' must not be empty";
        OperationResult result = new OperationResult("Create architectural view element");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(creationInfo.getValidator().getRootNode());
        ArchitecturalViewNode node = OperationHandler.opCreateElement(loadedInfo.getPresentationMode(), creationInfo, name, loadedInfo.getRepresentation());
        CreateElementOperation op = new CreateElementOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), creationInfo.getValidator().getRootNode().getRelativePath(), -1, creationInfo.getValidator().getDescriptor().getType(), name, creationInfo.getValidator().getDescriptor());
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION, node));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult createFinding(IWorkerContext workerContext, ArchitecturalViewFindingProperties properties) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteDependency' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'createFinding' must not be null";
        OperationResult result = new OperationResult("Create finding");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(properties.getRepresentation());
        CreateFindingOperation op = new CreateFindingOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), properties.getName(), properties.getDescription(), properties.ignoreViolations(), OperationHandler.createFinding(loadedInfo.getPresentationMode(), properties, loadedInfo.getFindingList(), loadedInfo.getRepresentation()));
        loadedInfo.getOperationList().addChild(op);
        loadedInfo.getFile().setNeedsSave(true);
        OperationHandler.operationCreatedAndApplied(loadedInfo.getFindingList(), loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getFile(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITHOUT_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public List<? extends ArchitecturalViewInfo<? extends Element>> createRefactoringList(IWorkerContext workerContext, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createRefactoringList' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createRefactoringList' must not be null";
        return RefactoringHandler.createRefactoringList(this.getLoadedRepresentationInfo(representation).getRepresentation());
    }

    @Override
    public List<? extends ArchitecturalViewInfo<? extends Element>> createViolationList(IWorkerContext workerContext, boolean includeIgnored, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createViolationList' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createViolationList' must not be null";
        return RefactoringHandler.createViolationList(includeIgnored, this.getLoadedRepresentationInfo(representation).getRepresentation());
    }

    @Override
    public ExplorationViewMetrics calculateMetrics(IWorkerContext workerContext, List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getMetrics' must not be empty";
        TreeSet<String> namespacePresentationNames = new TreeSet<String>();
        this.getSoftwareSystem().getUsedLanguages().forEach(l -> {
            boolean bl = namespacePresentationNames.add(l.getNamespacePresentationName());
        });
        return MetricsHandler.calculateMetrics(workerContext, elements, namespacePresentationNames);
    }
}

