/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.resolution;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.resolution.CreateResolutionCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IIssueExtension;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import java.util.List;

public final class CreateFixIssueCommand
extends CreateResolutionCommand<ICreateFixIssueInteraction> {
    public CreateFixIssueCommand(ISoftwareSystemProvider provider, ICreateFixIssueInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.CREATE_FIX_ISSUE_RESOLUTION;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CreateFixIssueData data = new CreateFixIssueData();
        if (((ICreateFixIssueInteraction)this.getInteraction()).collect(data)) {
            IIssueExtension issueExtension = this.getController().getSoftwareSystem().getExtension(IIssueExtension.class);
            OperationResultWithOutcome<List<Issue>> result = issueExtension.fix(workerContext, data.getIssues(), data.getComment(), data.getAssignee(), data.getPriority());
            ((ICreateFixIssueInteraction)this.getInteraction()).consumeMatchedIssuesInfo((List)result.getOutcome());
            ((ICreateFixIssueInteraction)this.getInteraction()).processCreateFixIssueResult((OperationResult)result);
        }
    }

    public static final class CreateFixIssueData
    extends CreateResolutionCommand.CreateResolutionData {
        private String m_assignee;
        private Priority m_priority;

        CreateFixIssueData() {
        }

        public void setAssignee(String assignee) {
            assert (assignee != null) : "Parameter 'assignee' of method 'setAssignee' must not be null";
            this.m_assignee = assignee;
        }

        String getAssignee() {
            assert (this.m_assignee != null) : "'m_assignee' of method 'getAssignee' must not be null";
            return this.m_assignee;
        }

        public void setPriority(Priority priority) {
            assert (priority != null) : "Parameter 'priority' of method 'setPriority' must not be null";
            this.m_priority = priority;
        }

        public Priority getPriority() {
            assert (this.m_priority != null) : "'m_priority' of method 'getPriority' must not be null";
            return this.m_priority;
        }
    }

    public static interface ICreateFixIssueInteraction
    extends CreateResolutionCommand.ICreateResolutionInteraction {
        public boolean collect(CreateFixIssueData var1);

        public void processCreateFixIssueResult(OperationResult var1);
    }
}

