/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.qualitygate;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityGateExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;

public final class CreateQualityGateCommand
extends SoftwareSystemBasedCommand<IQualityGateInteraction> {
    private QualityGate m_qualityGate;

    public CreateQualityGateCommand(ISoftwareSystemProvider provider, IQualityGateInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_QUALITY_GATE;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        QualityGateInteractionData data = new QualityGateInteractionData();
        if (!((IQualityGateInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IQualityGateExtension extension = this.getController().getSoftwareSystem().getExtension(IQualityGateExtension.class);
        OperationResultWithOutcome<QualityGate> result = extension.create(workerContext, data.getName(), data.getDescription());
        this.m_qualityGate = (QualityGate)result.getOutcome();
        ((IQualityGateInteraction)this.getInteraction()).handleResult(result);
    }

    public QualityGate getQualityGate() {
        return this.m_qualityGate;
    }

    public static interface IQualityGateInteraction
    extends ICommandInteraction {
        public boolean collect(QualityGateInteractionData var1);

        public void handleResult(OperationResultWithOutcome<QualityGate> var1);
    }

    public static class QualityGateInteractionData
    implements ICommandInteractionData {
        private String m_name;
        private String m_description;

        public void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public void setDescription(String description) {
            assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
            this.m_description = description;
        }

        public String getDescription() {
            return this.m_description;
        }
    }
}

