/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.system.CreateRepresentationCommand;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public abstract class FocusRepresentationCommand<T extends NodeAndEdgeRepresentation>
extends CreateRepresentationCommand<T> {
    private final T m_representationToFocus;
    private final Collection<RepresentationNode> m_elementsToFocus;
    private final Set<CoreParserDependencyType> m_dependencyTypes;
    private final EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> m_properties;
    private final FocusMode m_focusMode;

    public FocusRepresentationCommand(ISoftwareSystemProvider controller, T representationToFocus, Collection<RepresentationNode> elementsToFocus, Set<CoreParserDependencyType> dependencyTypes, FocusMode focusMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties) {
        super(controller);
        assert (representationToFocus != null) : "Parameter 'representationToFocus' of method 'FocusRepresentationCommand' must not be null";
        assert (elementsToFocus != null) : "Parameter 'elementsToFocus' of method 'FocusRepresentationCommand' must not be null";
        assert (dependencyTypes != null) : "Parameter 'dependencyTypes' of method 'FocusRepresentationCommand' must not be null";
        assert (focusMode != null) : "Parameter 'focusMode' of method 'FocusRepresentationCommand' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'FocusRepresentationCommand' must not be null";
        this.m_representationToFocus = representationToFocus;
        this.m_elementsToFocus = elementsToFocus;
        this.m_dependencyTypes = dependencyTypes;
        this.m_focusMode = focusMode;
        this.m_properties = properties;
    }

    @Override
    public final Result isEnabled() {
        Result enabled = super.isEnabled();
        if (this.m_representationToFocus == null) {
            enabled.addErrorMessage("No representation to focus");
        }
        if (this.m_elementsToFocus == null) {
            enabled.addErrorMessage("No elements to focus");
        }
        if (this.m_focusMode == null) {
            enabled.addErrorMessage("No focus mode suppiled");
        }
        return enabled;
    }

    protected final T getRepresentationToFocus() {
        return this.m_representationToFocus;
    }

    protected final Collection<RepresentationNode> getElementsToFocus() {
        return Collections.unmodifiableCollection(this.m_elementsToFocus);
    }

    public Set<CoreParserDependencyType> getDependencyTypes() {
        return Collections.unmodifiableSet(this.m_dependencyTypes);
    }

    protected final FocusMode getFocusMode() {
        return this.m_focusMode;
    }

    public EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> getRepresentationProperties() {
        return this.m_properties;
    }
}

