/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGroovyExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IUndoRedoExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.script.ScriptDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class EditGroovyScriptsDirectoryPathCommand
extends SoftwareSystemBasedCommand<IEditScriptsDirectoryInteraction> {
    public EditGroovyScriptsDirectoryPathCommand(ISoftwareSystemProvider provider, IEditScriptsDirectoryInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EDIT_GOOVY_SCRIPTS_DIRECTORY;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        IModifiableFile scriptRunnerFile;
        EditScriptsDirectoryInteractionData data = new EditScriptsDirectoryInteractionData();
        if (!((IEditScriptsDirectoryInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = new OperationResult("Rename script directory '" + data.getDirectoryToBeModified().getShortName() + "' to '" + data.getModifiedName() + "'");
        SoftwareSystem softwareSystem = this.getController().getSoftwareSystem();
        IGroovyExtension extension = softwareSystem.getExtension(IGroovyExtension.class);
        ITextValidator validator = extension.getDirectoryNameValidator(data.getDirectoryToBeModified().getParent(DirectoryPath.class, new Class[0]));
        ValidationResult validationResult = validator.isValid(data.getDirectoryToBeModified().getShortName(), data.getModifiedName());
        if (validationResult.isFailure()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.UNEXPECTED_DIRECTORY_NAME, data.getModifiedName(), new Object[0]);
            ((IEditScriptsDirectoryInteraction)this.getInteraction()).processOperationResult(result);
            return;
        }
        IUndoRedoExtension undoRedoExtension = softwareSystem.getExtension(IUndoRedoExtension.class);
        if (undoRedoExtension != null && (scriptRunnerFile = softwareSystem.getUniqueExistingChild(Files.class).getAnalyzers().getUniqueChild(new ShortNameFilter(CoreAnalyzerId.SCRIPT_RUNNER.getStandardName() + CoreFileType.ANALYZER_CONFIGURATION.getDefaultExtension()), IModifiableFile.class)) != null && undoRedoExtension.getHistorySize(scriptRunnerFile) > 0) {
            ((IEditScriptsDirectoryInteraction)this.getInteraction()).notifyAboutHistoryChanges(scriptRunnerFile.getIdentifyingPath());
        }
        result = extension.editScriptsDirectory(workerContext, data.getDirectoryToBeModified(), data.getModifiedName());
        ((IEditScriptsDirectoryInteraction)this.getInteraction()).processOperationResult(result);
    }

    public static class EditScriptsDirectoryInteractionData
    implements ICommandInteractionData {
        private ScriptDirectory m_directoryToBeModified;
        private String m_modifiedName;

        public void setDirectoryToBeModified(ScriptDirectory path) {
            assert (path != null) : "Parameter 'path' of method 'setDirectoryToBeModified' must not be null";
            this.m_directoryToBeModified = path;
        }

        public ScriptDirectory getDirectoryToBeModified() {
            return this.m_directoryToBeModified;
        }

        public void setModifiedName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setNewName' must not be empty";
            this.m_modifiedName = name;
        }

        public String getModifiedName() {
            return this.m_modifiedName;
        }
    }

    public static interface IEditScriptsDirectoryInteraction
    extends ICommandInteraction {
        public boolean collect(EditScriptsDirectoryInteractionData var1);

        public void processOperationResult(OperationResult var1);

        public void notifyAboutHistoryChanges(String var1);
    }
}

