/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InstCompilerDefinitionFromBundle
extends InstCompilerDefinition {
    private static final String MAC_DEFAULT_SYSTEM_FRAMEWORK_2 = "-F/Library/Frameworks";
    private static final String MAC_DEFAULT_SYSTEM_FRAMEWORK_1 = "-F/System/Library/Frameworks";
    private final URL m_url;

    public InstCompilerDefinitionFromBundle(NamedElement parent, URL url, String compiler) {
        super(parent, compiler);
        assert (url != null) : "Parameter 'url' of method 'InstCompilerDefinitionFromBundle' must not be null";
        this.m_url = url;
    }

    public URL getUrl() {
        return this.m_url;
    }

    public String getShortName() {
        String file = this.m_url.getFile();
        int lastSlashPos = file.lastIndexOf(47);
        if (lastSlashPos > 0) {
            return this.stripOffFileExtensionFromName(file.substring(lastSlashPos + 1));
        }
        return this.stripOffFileExtensionFromName(file);
    }

    @Override
    public String addImplicitCommonOptions(String rawText) {
        if (rawText == null) {
            rawText = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(super.addImplicitCommonOptions(rawText));
        if (Platform.isMac()) {
            if (sb.length() == 0) {
                sb.append(MAC_DEFAULT_SYSTEM_FRAMEWORK_1);
                sb.append(StringUtility.DEFAULT_LINE_SEPARATOR);
                sb.append(MAC_DEFAULT_SYSTEM_FRAMEWORK_2);
                sb.append(StringUtility.DEFAULT_LINE_SEPARATOR);
            } else {
                Matcher matcher1 = Pattern.compile(MAC_DEFAULT_SYSTEM_FRAMEWORK_1, 2).matcher(sb.toString());
                Matcher matcher2 = Pattern.compile(MAC_DEFAULT_SYSTEM_FRAMEWORK_2, 2).matcher(sb.toString());
                if (!matcher1.find()) {
                    sb.append(MAC_DEFAULT_SYSTEM_FRAMEWORK_1);
                    sb.append(StringUtility.DEFAULT_LINE_SEPARATOR);
                }
                if (!matcher2.find()) {
                    sb.append(MAC_DEFAULT_SYSTEM_FRAMEWORK_2);
                    sb.append(StringUtility.DEFAULT_LINE_SEPARATOR);
                }
            }
        }
        return sb.toString();
    }
}

