/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

abstract class AbstractSourceFileExtensions
extends NamedElement {
    public static final String SEPARATOR = ",";
    private final Set<String> m_fileExtensions = new HashSet<String>();

    public AbstractSourceFileExtensions(NamedElement parent, Set<String> fileExtensions) {
        super(parent);
        assert (fileExtensions != null) : "Parameter 'fileExtensions' of method 'AbstractSourceFileExtensions' must not be null";
        for (String extension : fileExtensions) {
            this.m_fileExtensions.add(extension.trim());
        }
    }

    @Property
    abstract String getDefaultSourceFileExtension();

    public String getShortName() {
        return ((Object)((Object)this)).getClass().getName() + " of " + this.getParent().getShortName();
    }

    public String toString() {
        return StringUtility.concat(this.m_fileExtensions, (String)SEPARATOR);
    }

    public Set<String> getSourceFileExtensions() {
        return Collections.unmodifiableSet(this.m_fileExtensions);
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        for (String extension : this.m_fileExtensions) {
            writer.writeString(extension);
        }
        writer.writeString(null);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        String extension = reader.readString();
        while (extension != null) {
            this.m_fileExtensions.add(extension);
            extension = reader.readString();
        }
    }
}

