/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.ObjectWriter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.CPlusPlusParser;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.CompilationUnitProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.DiagnosticMode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppCompilationUnit;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParsingServiceMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsingServiceMain.class);
    private final int m_id;
    private CPlusPlusParser m_parser;
    private String m_tempDir;
    private boolean m_recordCommands = false;
    private boolean m_productionMode = true;
    private Writer m_commandOutput;
    private StringBuilder m_commandBuffer;

    public ParsingServiceMain(int id) {
        this.m_id = id;
        this.init();
        this.m_productionMode = false;
    }

    private ParsingServiceMain(String[] args) {
        assert (args != null && args.length >= 1) : "Parameter 'args' of method 'ParsingServiceMain' must at least contain 1 argument";
        this.m_id = Integer.valueOf(args[0]);
        if (args.length > 1) {
            this.m_recordCommands = args[1].equals("-r");
            this.m_commandBuffer = new StringBuilder(4096);
        }
        this.init();
    }

    private void init() {
        TrueZipFacade.initialize();
        this.m_tempDir = System.getProperty("java.io.tmpdir");
        if (!this.m_tempDir.endsWith("/")) {
            this.m_tempDir = String.valueOf(this.m_tempDir) + "/";
        }
    }

    private String readLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (this.m_recordCommands && line != null) {
            this.m_commandBuffer.append(line).append('\n');
        }
        return line;
    }

    private void writeCommands() throws IOException {
        if (this.m_recordCommands && this.m_commandOutput != null) {
            this.m_commandOutput.write(this.m_commandBuffer.toString());
            this.m_commandBuffer.setLength(0);
            this.m_commandOutput.flush();
        }
    }

    public void run(InputStream in) throws IOException {
        block10: {
            String command;
            LOGGER.info("C,C++ parsing daemon '" + this.m_id + "' started and ready to receive commands");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while (true) {
                if ((command = this.readLine(reader)) == null) {
                    LOGGER.error("Unexpected end of command stream. Exiting daemon...");
                    break block10;
                }
                if (command.equals("INIT")) {
                    DiagnosticMode mode = DiagnosticMode.valueOf(this.readLine(reader));
                    TFile projectDataDir = new TFile(this.readLine(reader));
                    TFile diagnosticDir = new TFile(this.readLine(reader));
                    int longSize = Integer.valueOf(this.readLine(reader));
                    int pointerSize = Integer.valueOf(this.readLine(reader));
                    int wcharSize = Integer.valueOf(this.readLine(reader));
                    int restart = Integer.valueOf(this.readLine(reader));
                    EDG.configure(longSize, pointerSize, wcharSize);
                    this.m_parser = new CPlusPlusParser(mode, projectDataDir, diagnosticDir);
                    if (this.m_recordCommands) {
                        TFile outputFile = new TFile((File)diagnosticDir, "commands-" + this.m_id + ".txt");
                        this.m_commandOutput = new FileWriter((File)outputFile, restart == 1);
                    }
                    this.sendReply("OK");
                    continue;
                }
                if (command.equals("PARSE")) {
                    this.parse(reader);
                    System.gc();
                    continue;
                }
                if (!command.equals("PREPROCESS")) break;
                this.preprocess(reader);
            }
            if (command.equals("QUIT")) {
                this.sendReply("OK");
                if (this.m_commandOutput != null) {
                    this.m_commandOutput.close();
                    this.m_commandOutput = null;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Unexpected sleep interruption");
                }
                LOGGER.info("Exiting daemon...");
            } else {
                LOGGER.error("Unknown command: " + command + ". Exiting daemon...");
            }
        }
    }

    private void preprocess(BufferedReader reader) throws IOException {
        String option;
        String fileName = this.readLine(reader);
        ArrayList<String> options = new ArrayList<String>();
        while ((option = this.readLine(reader)) != null && option.length() > 0) {
            options.add(option);
        }
        this.writeCommands();
        LOGGER.info("Preprocesing for diagnostics '" + fileName + "'");
        this.m_parser.invokePreprocesor(new TFile(fileName), options);
        LOGGER.info("Preprocesing of '" + fileName + "'  finished");
        if (this.m_productionMode) {
            System.out.println(0);
            System.out.flush();
        }
    }

    private void parse(BufferedReader reader) throws IOException {
        String option;
        assert (reader != null) : "Parameter 'reader' of method 'parse' must not be null";
        String fileName = this.readLine(reader);
        ArrayList<String> options = new ArrayList<String>();
        while ((option = this.readLine(reader)) != null && option.length() > 0) {
            options.add(option);
        }
        this.writeCommands();
        TFile source = new TFile(fileName);
        CompilationUnitProcessor cup = new CompilationUnitProcessor(source, options);
        long time = System.currentTimeMillis();
        LOGGER.info("Parsing '" + fileName + "'");
        LOGGER.debug("Options: " + String.valueOf(options));
        int parserResult = this.m_parser.invokeParser(new TFile(fileName), options, cup.getRootVisitor());
        time = System.currentTimeMillis() - time;
        LOGGER.info("Parsing of '" + fileName + "' finished after " + time + "ms with status: " + parserResult);
        if (this.m_productionMode) {
            if (parserResult != 4 && parserResult >= 0) {
                CppCompilationUnit cu = cup.getRoot();
                ObjectWriter writer = new ObjectWriter();
                String parserModelFileName = this.m_tempDir + "pd" + this.m_id + "-" + String.valueOf(UUID.randomUUID()) + ".snapshot";
                TFile parserModelFile = new TFile(parserModelFileName);
                writer.store(parserModelFile, (IPersistable)cu);
                System.out.println(parserResult);
                System.out.println(parserModelFile.getNormalizedAbsolutePath());
            } else {
                System.out.println(parserResult);
            }
            System.out.flush();
        }
    }

    private void sendReply(String reply) throws IOException {
        if (this.m_productionMode) {
            System.out.println(reply);
            System.out.flush();
            this.writeCommands();
        }
    }

    public static void main(String[] args) {
        ParsingServiceMain ps = new ParsingServiceMain(args);
        try {
            ps.run(System.in);
        }
        catch (Throwable e) {
            try {
                String reply = "Exception: " + e.getClass().getName();
                if (e.getMessage() != null) {
                    reply = reply + ": " + e.getMessage();
                }
                ps.sendReply(reply);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.error("Daemon failed with exception", e);
        }
    }
}

