/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericFunction;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoFunction
extends GenericFunction
implements IRefactorable {
    private List<String> m_parameterTypes;
    private List<String> m_returnTypes;
    private List<String> m_typeParameters;

    public GoFunction(NamedElement parent) {
        super(parent);
    }

    public GoFunction(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int numberOfParameters) {
        super(msp, parent, name, lineNumber, numberOfParameters);
    }

    public final ProgrammingElement getOriginal() {
        if (!this.isExternal()) {
            return (ProgrammingElement)this.getOriginal(this.getModelServiceProvider());
        }
        return this;
    }

    public final ProgrammingElement getRepresentative() {
        if (!this.isExternal()) {
            return (ProgrammingElement)this.getRepresentative(this.getModelServiceProvider());
        }
        return this;
    }

    public String getFullyQualifiedNamePart() {
        return this.getPresentationName(true);
    }

    public List<String> getArgumentTypes() {
        return this.m_parameterTypes;
    }

    public void setParameterTypes(List<String> parameterTypes) {
        this.m_parameterTypes = parameterTypes;
    }

    public List<String> getReturnTypes() {
        return this.m_returnTypes;
    }

    public void setReturnTypes(List<String> returnTypes) {
        this.m_returnTypes = returnTypes;
    }

    public List<String> getTypeParameters() {
        return this.m_typeParameters;
    }

    public void setTypeParameters(List<String> typeParameters) {
        this.m_typeParameters = typeParameters;
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        String paramTypesStr = reader.readString();
        String returnTypesStr = reader.readString();
        String typeParamsStr = reader.readString();
        String[] paramTypes = paramTypesStr.split(";");
        String[] returnTypes = returnTypesStr.split(";");
        String[] typeParams = typeParamsStr.split(";");
        this.m_parameterTypes = new ArrayList<String>(paramTypes.length);
        this.m_returnTypes = new ArrayList<String>(returnTypes.length);
        this.m_typeParameters = new ArrayList<String>(typeParams.length);
        Arrays.stream(paramTypes).forEach(pt -> {
            boolean bl = this.m_parameterTypes.add((String)pt);
        });
        Arrays.stream(returnTypes).forEach(rt -> {
            boolean bl = this.m_returnTypes.add((String)rt);
        });
        Arrays.stream(typeParams).forEach(tp -> {
            boolean bl = this.m_typeParameters.add((String)tp);
        });
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(Joiner.join(this.m_parameterTypes, (String)";"));
        writer.writeString(Joiner.join(this.m_returnTypes, (String)";"));
        writer.writeString(Joiner.join(this.m_typeParameters, (String)";"));
    }

    public String getPresentationName(boolean shortName) {
        StringBuilder sb = new StringBuilder();
        if (!shortName && this.getParent() instanceof ProgrammingElement) {
            sb.append(this.getParent().getPresentationName(shortName)).append('.');
        }
        sb.append(this.getShortName());
        if (this.m_typeParameters.size() > 0) {
            sb.append('[').append(Joiner.join(this.m_typeParameters)).append(']');
        }
        sb.append('(').append(Joiner.join(this.m_parameterTypes)).append(')');
        if (this.m_returnTypes.size() > 0) {
            if (this.m_returnTypes.size() > 1) {
                sb.append('(').append(Joiner.join(this.m_returnTypes)).append(')');
            } else {
                sb.append(' ').append(this.m_returnTypes.get(0));
            }
        }
        return sb.toString();
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGoFunction(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitGoFunction(GoFunction var1);
    }
}

