/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.command.system;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.go.command.system.GoCommandId;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.GoWorkspaceExtension;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;

public final class CreateNewGoSystemCommand
extends AbstractCreateSoftwareSystemCommand {
    public static final ICommandId ID = GoCommandId.CREATE_SOFTWARE_SYSTEM_FROM_FROM_GO_MODULES;
    private final IInteraction m_interaction;

    public CreateNewGoSystemCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreateNewTypescriptSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return ID;
    }

    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CreateSoftwareSystemCommand createSoftwareSystemCommand = new CreateSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (AbstractCreateSoftwareSystemCommand.IInteraction)this.m_interaction);
        if (!createSoftwareSystemCommand.isEnabled().isSuccess()) {
            return;
        }
        GoSystemData data = new GoSystemData();
        if (!this.m_interaction.collectGoModFiles(data)) {
            return;
        }
        this.runPrerequisiteCommand((Command)createSoftwareSystemCommand, workerContext);
        if (createSoftwareSystemCommand.canceled() || !this.getController().hasSoftwareSystem()) {
            return;
        }
        Installation installation = this.getController().getInstallation();
        GoWorkspaceExtension wsExt = (GoWorkspaceExtension)installation.getExtension(GoWorkspaceExtension.class);
        OperationResult result = new OperationResult("Initializing Go System");
        wsExt.initGoSoftwareSystem(result, this.getController().getSoftwareSystem(), data.getGoModFiles());
        if (!result.isFailure()) {
            OperationResult saveResult = this.getController().saveSoftwareSystem();
            result.addMessagesFrom(saveResult);
        }
        if (result.isFailure() || result.containsWarning()) {
            this.m_interaction.processResult(result);
        }
    }

    public static class GoSystemData
    implements ICommandInteractionData {
        private final List<TFile> m_goModFiles = new ArrayList<TFile>();

        public List<TFile> getGoModFiles() {
            return this.m_goModFiles;
        }

        public void addGoModFile(TFile goModFile) {
            assert (goModFile != null) : "Parameter 'goModFile' of method 'addGoModFile' must not be null";
            this.m_goModFiles.add(goModFile);
        }

        boolean isEmpty() {
            return this.m_goModFiles.isEmpty();
        }
    }

    public static interface IInteraction
    extends AbstractCreateSoftwareSystemCommand.IInteraction {
        public boolean collectGoModFiles(GoSystemData var1);

        public void processResult(OperationResult var1);
    }
}

