/*
 * Decompiled with CFR 0.152.
 */
package com.h2m.common.observer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Observable {
    private final Map<String, List<IObserver>> m_EventToObservers = new HashMap<String, List<IObserver>>();

    protected Observable(String ... events) {
        assert (events != null) : "'events' must not be null";
        assert (events.length > 0) : "At least one event needs to be defined";
        for (String nextEvent : events) {
            List previous = this.m_EventToObservers.put(nextEvent, new ArrayList());
            assert (previous == null) : "Duplicate event defined: " + nextEvent;
        }
    }

    public final void addObserver(IObserver observer, String event) {
        assert (observer != null) : "'observer' must not be null";
        assert (event != null) : "'event' must not be null";
        assert (this.m_EventToObservers.containsKey(event)) : "Event not supported: " + event;
        assert (!this.m_EventToObservers.get(event).contains(observer)) : "Observer already added" + observer;
        this.m_EventToObservers.get(event).add(observer);
    }

    protected final void notifyAboutEvent(String event) {
        assert (event != null) : "'event' must not be null";
        assert (this.m_EventToObservers.containsKey(event)) : "Event not supported: " + event;
        for (IObserver nextObserver : this.m_EventToObservers.get(event)) {
            nextObserver.handleEvent(this, event);
        }
    }

    public static interface IObserver {
        public void handleEvent(Observable var1, String var2);
    }
}

