/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.ui;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BuildWaitForCommandCompletion {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildWaitForCommandCompletion.class);
    private final Command m_command;
    private final IWorkerContext m_workerContext;
    private Boolean m_commandFinished;
    private CommandException m_exception;

    public BuildWaitForCommandCompletion(Command command, IWorkerContext workerContext) {
        assert (command != null) : "Parameter 'command' of method 'WaitForCommandCompletion' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'WaitForCommandCompletion' must not be null";
        this.m_command = command;
        this.m_workerContext = workerContext;
    }

    public BuildWaitForCommandCompletion(Command command) {
        assert (command != null) : "Parameter 'command' of method 'WaitForCommandCompletion' must not be null";
        this.m_command = command;
        this.m_workerContext = null;
    }

    public CommandException getCommandExecutionException() {
        return this.m_exception;
    }

    public void run() {
        assert (this.m_commandFinished == null) : "Parameter 'm_commandFinished' of method 'run' must be null";
        this.m_commandFinished = Boolean.FALSE;
        this.m_command.run((IWorkerContext)(this.m_workerContext != null ? this.m_workerContext : DefaultWorkerContext.INSTANCE), new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                LOGGER.debug("Consuming: {}", (Object)BuildWaitForCommandCompletion.this.m_command.getId());
                BuildWaitForCommandCompletion.this.m_commandFinished = Boolean.TRUE;
                BuildWaitForCommandCompletion.this.m_exception = exception;
            }
        });
        do {
            try {
                if (LOGGER.isDebugEnabled()) {
                    Thread.sleep(250L);
                    LOGGER.debug("Waiting for command to complete...");
                    continue;
                }
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.m_commandFinished == Boolean.FALSE);
    }
}

