/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.foundation.common;

import com.hello2morrow.sonargraph.foundation.activity.Activity;
import com.hello2morrow.sonargraph.foundation.activity.WorkerContext;
import java.util.Arrays;

public final class DetailedProgressConsoleWorkerContext
extends WorkerContext {
    private String m_lastMessage = "";
    private boolean m_isLastMessageProgress = false;

    protected void activityUpdated(Activity activity) {
        if (this.m_isLastMessageProgress) {
            this.moveBackCursor();
        }
        if (activity.isRunning()) {
            if (activity.hasJustBeenStarted() && activity.isMainStep()) {
                this.log(activity.getCurrentMessage(), false);
            } else if (activity.providesProgress() && activity.getWorkedInPercent() > 0) {
                this.log(String.format("%s [%d%%]", activity.getCurrentMessage(), activity.getWorkedInPercent()), true);
            }
        } else if (this.m_isLastMessageProgress) {
            System.out.print(this.createBlanks(this.m_lastMessage.length()));
            this.moveBackCursor();
        }
    }

    private void log(String message, boolean isProgress) {
        StringBuilder messageToPrint = new StringBuilder(message.length());
        if (!isProgress) {
            if (this.m_isLastMessageProgress) {
                messageToPrint.append('\n');
            }
            messageToPrint.append(message);
            System.out.println(messageToPrint.toString());
            this.m_lastMessage = "";
            this.m_isLastMessageProgress = false;
        } else {
            messageToPrint.append(message);
            int diff = this.m_lastMessage.trim().length() - message.length();
            if (diff > 0) {
                messageToPrint.append(this.createBlanks(diff));
            }
            this.m_lastMessage = messageToPrint.toString();
            System.out.print(this.m_lastMessage);
            System.out.flush();
            this.m_isLastMessageProgress = true;
        }
    }

    private char[] createBlanks(int length) {
        char[] blanks = new char[length];
        Arrays.fill(blanks, ' ');
        return blanks;
    }

    private void moveBackCursor() {
        int length = this.m_lastMessage.length();
        if (length <= 0) {
            return;
        }
        char[] chars = new char[length];
        Arrays.fill(chars, '\b');
        System.out.print(chars);
        System.out.flush();
    }
}

