/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.detector;

import com.hello2morrow.sonargraph.build.client.detector.ProjectFolder;
import com.hello2morrow.sonargraph.build.client.detector.ProjectUnit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SimpleRootDirectoryDetector {
    private static final String CLASS_EXT = ".class";
    private static final String JAVA_EXT = ".java";
    private static final Pattern PATTERN = Pattern.compile("^[ \t]*package[ \t]*(.*)[ \t]*;");
    private final List<File> m_classFileDirectories = new ArrayList<File>();
    private final List<File> m_sourceDirectories = new ArrayList<File>();
    private final Set<String> m_packageStarts = new HashSet<String>();
    private String m_rootPackage;

    private String extractPackageName(File sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'extractPackageName' must not be null";
        Charset cs = Charset.forName("UTF-8");
        int retries = 0;
        do {
            try {
                for (String line : Files.readAllLines(sourceFile.toPath(), cs)) {
                    Matcher matcher = PATTERN.matcher(line);
                    if (!matcher.matches()) continue;
                    return matcher.group(1);
                }
            }
            catch (MalformedInputException e) {
                cs = Charset.forName("ISO-8859-1");
                ++retries;
            }
            catch (IOException e) {
                break;
            }
        } while (retries < 2);
        return "";
    }

    private boolean doDetect(File root) {
        assert (root != null) : "Parameter 'root' of method 'doDetect' must not be null";
        File[] files = root.listFiles();
        if (files != null) {
            String name;
            for (File file : files) {
                if (file.isDirectory()) continue;
                name = file.getName();
                if (name.endsWith(CLASS_EXT)) {
                    this.m_classFileDirectories.add(root);
                    return false;
                }
                if (!name.endsWith(JAVA_EXT)) continue;
                String packageName = this.extractPackageName(file);
                int firstDot = packageName.indexOf(46);
                this.m_rootPackage = firstDot != -1 ? packageName.substring(0, firstDot) : packageName;
                if (this.m_rootPackage.length() > 0) {
                    this.m_packageStarts.add(this.m_rootPackage);
                    return true;
                }
                this.m_sourceDirectories.add(root);
                return false;
            }
            for (File file : files) {
                if (!file.isDirectory() || (name = file.getName()).startsWith(".") || name.equalsIgnoreCase("test") || name.equalsIgnoreCase("suites") || name.endsWith("Test") || name.contains("jacoco") || !this.doDetect(file)) continue;
                if (this.m_rootPackage.equals(file.getName())) {
                    this.m_sourceDirectories.add(root);
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public ProjectFolder detect(File root) {
        assert (root != null) : "Parameter 'root' of method 'detect' must not be null";
        this.doDetect(root);
        LinkedHashSet<File> classDirs = new LinkedHashSet<File>();
        Iterator<File> iterator = this.m_classFileDirectories.iterator();
        while (iterator.hasNext()) {
            File classDir;
            File dir = classDir = iterator.next();
            while (!this.m_packageStarts.contains(dir.getName())) {
                if ((dir = dir.getParentFile()) != null) continue;
                classDirs.add(classDir);
                break;
            }
            if (dir == null) continue;
            classDirs.add(dir.getParentFile());
        }
        this.m_classFileDirectories.clear();
        this.m_classFileDirectories.addAll(classDirs);
        ProjectFolder folder = new ProjectFolder(root);
        File buildDir = new File(new File(new File(root, "build"), "classes"), "java");
        File[] files = root.listFiles();
        if (files != null) {
            for (File dir : files) {
                List<File> matchingSourceDirs;
                if (!dir.isDirectory() || dir.getName().startsWith(".") || dir.getName().equals("build") || (matchingSourceDirs = this.m_sourceDirectories.stream().filter(d -> d.getPath().startsWith(dir.getPath() + File.separatorChar)).collect(Collectors.toList())).isEmpty()) continue;
                if (((File)matchingSourceDirs.get(0)).getName().contains("java")) {
                    List<File> matchingClassDirs = this.m_classFileDirectories.stream().filter(d -> d.getPath().startsWith(dir.getPath() + File.separatorChar)).collect(Collectors.toList());
                    String[] nameParts = dir.getName().split("-");
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String namePart : nameParts) {
                        stringBuilder.append(SimpleRootDirectoryDetector.capitalize(namePart));
                    }
                    ProjectUnit unit = new ProjectUnit(dir, stringBuilder.toString());
                    matchingSourceDirs.forEach(d -> unit.addSourceFolder((File)d));
                    matchingClassDirs.forEach(d -> unit.addClassFolder((File)d));
                    folder.addUnit(unit);
                    continue;
                }
                if (!buildDir.isDirectory()) continue;
                HashMap<String, ArrayList<File>> srcUnitMap = new HashMap<String, ArrayList<File>>();
                for (File file : matchingSourceDirs) {
                    String name = file.getName();
                    ArrayList<File> srcDirs = (ArrayList<File>)srcUnitMap.get(name);
                    if (srcDirs == null) {
                        srcDirs = new ArrayList<File>();
                        srcUnitMap.put(name, srcDirs);
                    }
                    srcDirs.add(file);
                }
                for (Map.Entry entry : srcUnitMap.entrySet()) {
                    String unitName = dir.getName() + SimpleRootDirectoryDetector.capitalize((String)entry.getKey());
                    ProjectUnit unit = new ProjectUnit(dir, SimpleRootDirectoryDetector.capitalize(unitName));
                    ((List)entry.getValue()).forEach(d -> unit.addSourceFolder((File)d));
                    File classDir = new File(buildDir, unitName);
                    if (!classDir.isDirectory()) continue;
                    unit.addClassFolder(classDir);
                    folder.addUnit(unit);
                }
            }
        }
        if (folder.isEmpty()) {
            return null;
        }
        return folder;
    }

    private static String capitalize(String s) {
        assert (s != null) : "Parameter 's' of method 'capitalize' must not be null";
        if (s.length() > 0) {
            return Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return s;
    }

    public static List<ProjectFolder> scanRoots(File root) {
        assert (root != null) : "Parameter 'root' of method 'scanRoots' must not be null";
        ArrayList<ProjectFolder> result = new ArrayList<ProjectFolder>();
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                SimpleRootDirectoryDetector detector;
                ProjectFolder folder;
                if (!file.isDirectory() || file.getName().startsWith(".") || (folder = (detector = new SimpleRootDirectoryDetector()).detect(file)) == null) continue;
                result.add(folder);
            }
        }
        return result;
    }
}

