/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.api;

import com.hello2morrow.sonargraph.build.api.RootPathInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ModuleInfo {
    private final String m_id;
    private final String m_name;
    private final String m_language;
    private final List<ModuleInfo> m_dependsUpon = new ArrayList<ModuleInfo>();
    private final List<RootPathInfo> m_rootPaths = new ArrayList<RootPathInfo>();
    private final String m_description;

    public ModuleInfo(String id, String name, String description, String language) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'ModuleInfo' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ModuleInfo' must not be empty";
        assert (language != null && language.length() > 0) : "Parameter 'language' of method 'ModuleInfo' must not be empty";
        this.m_id = id;
        this.m_name = name;
        this.m_description = description == null ? "" : description;
        this.m_language = language;
    }

    public String getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public List<ModuleInfo> getDependsUpon() {
        return Collections.unmodifiableList(this.m_dependsUpon);
    }

    public List<RootPathInfo> getRootPathsByCategory(RootPathInfo.Category category) {
        return this.m_rootPaths.stream().filter(root -> category == null || root.getCategory() == category).collect(Collectors.toList());
    }

    public int getNumberOfRootDirectories() {
        return this.m_rootPaths.size();
    }

    public void addModuleDependency(ModuleInfo module) {
        assert (module != null && module != this);
        this.m_dependsUpon.add(module);
    }

    public void addRootPath(RootPathInfo rootPath) {
        assert (rootPath != null && !this.m_rootPaths.contains(rootPath));
        this.m_rootPaths.add(rootPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\n roots=").append(this.m_rootPaths.toString()).append("\n dependencies=").append(this.m_dependsUpon.stream().map(ModuleInfo::getName).collect(Collectors.toList())).append('\n');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_dependsUpon == null ? 0 : this.m_dependsUpon.hashCode());
        result = 31 * result + (this.m_description == null ? 0 : this.m_description.hashCode());
        result = 31 * result + (this.m_id == null ? 0 : this.m_id.hashCode());
        result = 31 * result + (this.m_language == null ? 0 : this.m_language.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_rootPaths == null ? 0 : this.m_rootPaths.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleInfo other = (ModuleInfo)obj;
        if (this.m_dependsUpon == null ? other.m_dependsUpon != null : !this.m_dependsUpon.equals(other.m_dependsUpon)) {
            return false;
        }
        if (this.m_description == null ? other.m_description != null : !this.m_description.equals(other.m_description)) {
            return false;
        }
        if (this.m_id == null ? other.m_id != null : !this.m_id.equals(other.m_id)) {
            return false;
        }
        if (this.m_language == null ? other.m_language != null : !this.m_language.equals(other.m_language)) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        return !(this.m_rootPaths == null ? other.m_rootPaths != null : !this.m_rootPaths.equals(other.m_rootPaths));
    }
}

