/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IMetricCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricProvider;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementWithDescriptionImpl;
import java.util.Collections;
import java.util.List;

public final class MetricIdImpl
extends ElementWithDescriptionImpl
implements IMetricId {
    private static final long serialVersionUID = 6618223791961362393L;
    private final List<IMetricCategory> categories;
    private final List<IMetricLevel> levels;
    private final IMetricProvider provider;
    private final boolean isFloat;
    private final double worstValue;
    private final double bestValue;
    private final double maxValue;
    private final double minValue;
    private final IMetricId.SortDirection sortDirection;

    public MetricIdImpl(String name, String presentationName, String description, List<IMetricCategory> categories, List<IMetricLevel> levels, IMetricProvider provider, boolean isFloat, double bestValue, double worstValue, double minValue, double maxValue, IMetricId.SortDirection direction) {
        super(name, presentationName, description);
        assert (categories != null && !categories.isEmpty()) : "Parameter 'categories' of method 'setCategories' must not be empty";
        assert (levels != null && !levels.isEmpty()) : "Parameter 'levels' of method 'MetricIdImpl' must not be empty";
        assert (provider != null) : "Parameter 'provider' of method 'MetricId' must not be null";
        assert (direction != null) : "Parameter 'direction' of method 'MetricIdImpl' must not be null";
        this.categories = categories;
        this.levels = levels;
        this.provider = provider;
        this.isFloat = isFloat;
        this.bestValue = bestValue;
        this.worstValue = worstValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sortDirection = direction;
    }

    @Override
    public List<IMetricCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    @Override
    public IMetricProvider getProvider() {
        return this.provider;
    }

    @Override
    public boolean isFloat() {
        return this.isFloat;
    }

    @Override
    public List<IMetricLevel> getLevels() {
        return Collections.unmodifiableList(this.levels);
    }

    @Override
    public Double getBestValue() {
        return this.bestValue;
    }

    @Override
    public Double getWorstValue() {
        return this.worstValue;
    }

    @Override
    public double getWorst() {
        return this.worstValue;
    }

    @Override
    public double getBest() {
        return this.bestValue;
    }

    @Override
    public double getMin() {
        return this.minValue;
    }

    @Override
    public double getMax() {
        return this.maxValue;
    }

    @Override
    public IMetricId.SortDirection getSortDirection() {
        return this.sortDirection;
    }
}

