/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssueProvider;
import com.hello2morrow.sonargraph.integration.access.model.IIssueType;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import com.hello2morrow.sonargraph.integration.access.model.Severity;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementWithDescriptionImpl;
import java.util.List;

public abstract class IssueImpl
extends ElementWithDescriptionImpl
implements IIssue {
    private static final long serialVersionUID = -5954212635522758181L;
    private final IIssueType issueType;
    private final IIssueProvider issueProvider;
    private final int line;
    private final int column;
    private ResolutionType resolutionType = ResolutionType.NONE;

    public IssueImpl(String name, String presentationName, String description, IIssueType issueType, IIssueProvider provider, int line, int column) {
        super(name, presentationName, description != null ? description : "");
        assert (issueType != null) : "Parameter 'issueType' of method 'IssueImpl' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'Issue' must not be null";
        this.issueType = issueType;
        this.issueProvider = provider;
        this.line = line;
        this.column = column;
    }

    @Override
    public final IIssueProvider getIssueProvider() {
        return this.issueProvider;
    }

    @Override
    public final IIssueType getIssueType() {
        return this.issueType;
    }

    @Override
    public Severity getSeverity() {
        List<Severity> supportedSeverities = this.issueType.getSupportedSeverities();
        assert (supportedSeverities.size() == 1) : "No unique severity for issue " + String.valueOf(this);
        return supportedSeverities.get(0);
    }

    @Override
    public String getKey() {
        return this.issueType.getName() + ":" + this.issueProvider.getName();
    }

    public final void setResolutionType(ResolutionType resolutionType) {
        assert (resolutionType != null) : "Parameter 'resolutionType' of method 'setResolutionType' must not be null";
        this.resolutionType = resolutionType;
    }

    @Override
    public ResolutionType getResolutionType() {
        return this.resolutionType;
    }

    @Override
    public final boolean isIgnored() {
        return ResolutionType.IGNORE.equals(this.resolutionType);
    }

    @Override
    public final boolean hasResolution() {
        return !ResolutionType.NONE.equals(this.resolutionType);
    }

    @Override
    public final int getLine() {
        return this.line;
    }

    @Override
    public final int getColumn() {
        return this.column;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\n");
        builder.append("type:").append(this.issueType.getPresentationName());
        builder.append("\n");
        builder.append("provider:").append(this.issueProvider.getPresentationName());
        builder.append("\n");
        builder.append("severity:").append(this.getSeverity());
        builder.append("\n");
        builder.append("line:").append(this.line);
        builder.append("\n");
        if (this.resolutionType != null) {
            builder.append("resolutionType:").append(this.resolutionType);
        }
        return builder.toString();
    }
}

