/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class IssueContainer<T extends IIssue> {
    private final List<T> baselineSystemIssues = new ArrayList<T>(2);
    private final List<T> currentSystemIssues = new ArrayList<T>(2);

    public void addBaselineSystemIssue(T issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addBaselineSystemIssue' must not be null";
        this.baselineSystemIssues.add(issue);
    }

    public void addCurrentSystemIssue(T issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addCurrentSystemIssue' must not be null";
        this.currentSystemIssues.add(issue);
    }

    public void sort(Comparator<IIssue> comparator) {
        assert (comparator != null) : "Parameter 'comparator' of method 'sort' must not be null";
        Collections.sort(this.baselineSystemIssues, comparator);
        Collections.sort(this.currentSystemIssues, comparator);
    }

    public List<T> getBaselineSystemIssues() {
        return this.baselineSystemIssues;
    }

    public List<T> getCurrentSystemIssues() {
        return this.currentSystemIssues;
    }
}

