/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.apitest;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IMetaDataController;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultWithOutcome;
import com.hello2morrow.sonargraph.integration.access.model.IExportMetaData;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ExportMetaDataControllerTest {
    private static final String META_DATA_PATH = "./src/test/resources/ExportMetaData.xml";
    private static final String WRONG_ENCODING = "./src/test/resources/ExportMetaData_Prolog_Error.xml";
    private IMetaDataController m_controller;

    @Before
    public void before() {
        this.m_controller = ControllerFactory.createMetaDataController();
    }

    @Test
    public void testReadExportMetaData() throws IOException {
        File exportMetaDataFile = new File(META_DATA_PATH);
        ResultWithOutcome<IExportMetaData> result = this.m_controller.loadExportMetaData(exportMetaDataFile);
        Assert.assertTrue((String)("Failed to load metric meta-data file: " + result.toString()), (boolean)result.isSuccess());
        IExportMetaData metaData = result.getOutcome();
        Assert.assertEquals((String)"Identifier for metadata does not match", (Object)new File(META_DATA_PATH).getCanonicalPath(), (Object)metaData.getResourceIdentifier());
        Assert.assertEquals((String)"Wrong issue categories size", (long)13L, (long)metaData.getIssueCategories().size());
        Assert.assertNotNull((String)"Issue Category 'ArchitectureViolation' not found", (Object)metaData.getIssueCategories().get("ArchitectureViolation"));
        Assert.assertEquals((String)"Wrong issue providers size", (long)8L, (long)metaData.getIssueProviders().size());
        Assert.assertNotNull((String)"Issue Provier './Core/BadSmells/UnusedTypes.scr' not found", (Object)metaData.getIssueProviders().get("./Core/BadSmells/UnusedTypes.scr"));
        Assert.assertEquals((String)"Wrong issue types size", (long)109L, (long)metaData.getIssueTypes().size());
        Assert.assertNotNull((String)"Issue Type 'WorkspaceDependencyProblematic' not found", (Object)metaData.getIssueTypes().get("WorkspaceDependencyProblematic"));
        Assert.assertEquals((String)"Wrong metric categories size", (long)10L, (long)metaData.getMetricCategories().size());
        Assert.assertNotNull((String)"Metric category 'Architecture' not found", (Object)metaData.getMetricCategories().get("Architecture"));
        Assert.assertEquals((String)"Metric category 'JohnLakos' has wrong presentation name", (Object)"John Lakos", (Object)metaData.getMetricCategories().get("JohnLakos").getPresentationName());
        Map<String, IMetricLevel> metricLevelMap = metaData.getMetricLevels();
        Assert.assertEquals((String)"Wrong number of levels", (long)8L, (long)metricLevelMap.size());
        List<IMetricId> systemLevelMetrics = metaData.getMetricIdsForLevel(metricLevelMap.get("System"));
        Assert.assertEquals((String)"Wrong number of metrics for System level", (long)45L, (long)systemLevelMetrics.size());
        IMetricId coreLinesOfCode = metaData.getMetricIds().get("CoreLinesOfCode");
        Assert.assertThat((String)"Wrong number of levels for metric", coreLinesOfCode.getLevels(), (Matcher)CoreMatchers.hasItems((Object[])new IMetricLevel[]{metricLevelMap.get("System"), metricLevelMap.get("Module"), metricLevelMap.get("SourceFile")}));
        Assert.assertEquals((String)"Wrong number of metrics", (long)76L, (long)metaData.getMetricIds().size());
        Assert.assertEquals((String)"Metric id 'Unused Types' has wrong presentation name", (Object)"Number of Unused Types", (Object)metaData.getMetricIds().get("Unused Types").getPresentationName());
    }

    @Test
    public void testWrongEncoding() {
        File exportMetaDataFile = new File(WRONG_ENCODING);
        ResultWithOutcome<IExportMetaData> result = this.m_controller.loadExportMetaData(exportMetaDataFile);
        Assert.assertFalse((String)("Failure expected: " + result.toString()), (boolean)result.isSuccess());
    }

    @Test
    public void testReadExportMetaDataOfFourLanguagesSystem() {
        File exportMetaDataFile = new File("./src/test/data/multilanguage/ExportMetaDataFourLanguages.xml");
        ResultWithOutcome<IExportMetaData> result = this.m_controller.loadExportMetaData(exportMetaDataFile);
        Assert.assertTrue((String)("Failed to load metric meta-data file: " + result.toString()), (boolean)result.isSuccess());
        IExportMetaData metaData = result.getOutcome();
        Assert.assertNotNull((Object)metaData);
    }
}

