/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.system;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModuleType;
import java.io.IOException;

public class CSharpRoslynModule
extends CSharpModule {
    private String m_projectName;
    private String m_rootPath;

    public CSharpRoslynModule(NamedElement parent) {
        super(parent);
    }

    public CSharpRoslynModule(NamedElement parent, String name, String id, String projectName) {
        super(parent, name, id, CSharpModuleType.ROSLYN);
        assert (projectName != null && projectName.length() > 0) : "Parameter 'projectName' of method 'CSharpRoslynModule' must not be empty";
        this.m_projectName = projectName;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public void setRootPath(String rootPath) {
        this.m_rootPath = rootPath;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_projectName);
        writer.writeString(this.m_rootPath);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_projectName = reader.readString();
        this.m_rootPath = reader.readString();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpRoslynModule(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCSharpRoslynModule(CSharpRoslynModule var1);
    }
}

