/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn;

import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.PathReader;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpCauses;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DotnetSdkLocator {
    private static final Logger LOGGER;
    private static List<String> PATH;
    private static String DOTNET;
    private static String DOTNET_EXE;

    static {
        int n;
        String[] extraLocations;
        LOGGER = LoggerFactory.getLogger(DotnetSdkLocator.class);
        PATH = new ArrayList<String>();
        DOTNET_EXE = null;
        if (Platform.isWindows()) {
            String programFiles = System.getenv("ProgramFiles");
            if (programFiles == null || programFiles.length() == 0) {
                programFiles = "C:\\Program Files";
            }
            DOTNET = "dotnet.exe";
            extraLocations = new String[]{programFiles + "\\dotnet\\x64", programFiles + "\\dotnet"};
        } else if (Platform.isMac()) {
            DOTNET = "dotnet";
            extraLocations = new String[]{"/usr/local/share/dotnet", System.getenv("HOME") + "/.dotnet", "/usr/share/dotnet"};
        } else {
            DOTNET = "dotnet";
            extraLocations = new String[]{System.getenv("HOME") + "/.dotnet", "/usr/bin", "/usr/local/bin", "/usr/share/dotnet", "/usr/local/share/dotnet"};
        }
        String path = PathReader.readPathFromEnvironment();
        if (path != null) {
            String[] dirs;
            String[] stringArray = dirs = path.split(File.pathSeparator);
            int n2 = dirs.length;
            n = 0;
            while (n < n2) {
                String dir = stringArray[n];
                PATH.add(dir);
                ++n;
            }
        }
        String[] stringArray = extraLocations;
        n = extraLocations.length;
        int n3 = 0;
        while (n3 < n) {
            File dirFile;
            String dir = stringArray[n3];
            if (!PATH.contains(dir) && (dirFile = new File(dir)).isDirectory()) {
                PATH.add(dir);
            }
            ++n3;
        }
    }

    private DotnetSdkLocator() {
    }

    private static String locateDotnetSdk(String dotnetExe, OperationResult result) {
        TFile newestSdkPath;
        block10: {
            Version newestVersion;
            Version newestDotNetVersion;
            block9: {
                assert (dotnetExe != null) : "Parameter 'dotnetExe' of method 'locateDotnetSdk' must not be null";
                assert (result != null) : "Parameter 'result' of method 'locateDotnetSdk' must not be null";
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.command(dotnetExe, "--list-sdks");
                try {
                    String sdk;
                    Process p = pb.start();
                    BufferedReader processOutput = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));
                    newestSdkPath = null;
                    newestDotNetVersion = null;
                    newestVersion = null;
                    Version.VersionComparator comparator = new Version.VersionComparator();
                    StringBuilder output = new StringBuilder();
                    while ((sdk = processOutput.readLine()) != null) {
                        int spacePos;
                        output.append(sdk).append('\n');
                        if (sdk.contains("preview") || (spacePos = sdk.indexOf(32)) <= 0) continue;
                        String versionString = sdk.substring(0, spacePos);
                        Version version = Version.create((String)versionString);
                        if (newestDotNetVersion != null && comparator.compare(version, newestDotNetVersion) <= 0) continue;
                        newestVersion = version;
                        if (version.getMajor() > 10) continue;
                        newestDotNetVersion = version;
                        String path = sdk.substring(spacePos + 2, sdk.length() - 1);
                        TFile sdkPath = new TFile((File)new TFile(path), versionString);
                        if (!sdkPath.isDirectory()) continue;
                        newestSdkPath = sdkPath;
                    }
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Unexpected process interruption", (Throwable)e);
                    }
                    if (newestDotNetVersion != null && newestSdkPath != null) break block9;
                    LOGGER.error("Unable to detect .Net SDK 10 versions from dotnet output:\n" + output.toString());
                    result.addError((OperationResult.IMessageCause)CSharpCauses.DOTNET_10_REQUIRED, "Could not determine installed .Net SDK versions from dotnet output. See logfile for details...", new Object[0]);
                    return null;
                }
                catch (IOException e) {
                    result.addError((OperationResult.IMessageCause)CSharpCauses.DOTNET_COMMAND_ERROR, "Could not start dotnet command: " + e.getMessage(), new Object[0]);
                    LOGGER.error("Could not start dotnet command: " + dotnetExe + ": " + e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            if (newestDotNetVersion.getMajor() >= 10) break block10;
            LOGGER.error("Only found .Net version " + newestDotNetVersion.toString());
            result.addError((OperationResult.IMessageCause)CSharpCauses.DOTNET_10_REQUIRED, "You must have .Net 10 installed. Highest version found was " + newestVersion.toString(), new Object[0]);
            return null;
        }
        return newestSdkPath.getNormalizedAbsolutePath();
    }

    static String locateDotnetSdk(OperationResult result) {
        String dotnetExe = DotnetSdkLocator.locateDotnetExecutable();
        if (dotnetExe == null) {
            LOGGER.error(String.format("Could not locate '%s'. Search path was: %s", DOTNET, Joiner.join(PATH)));
            result.addError((OperationResult.IMessageCause)CSharpCauses.DOTNET_COMMAND_ERROR, "Could not locate dotnet command (searched in: '" + Joiner.join(PATH) + "')", new Object[0]);
            return null;
        }
        return DotnetSdkLocator.locateDotnetSdk(dotnetExe, result);
    }

    public static String locateDotnetExecutable() {
        TFile dotnet = null;
        if (DOTNET_EXE == null) {
            for (String dir : PATH) {
                dotnet = new TFile(dir, DOTNET);
                if (!dotnet.exists()) continue;
                DOTNET_EXE = dotnet.getNormalizedAbsolutePath();
                break;
            }
        }
        return DOTNET_EXE;
    }
}

