/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.workspace.IWorkspaceSettingsElement;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class PythonInterpreter
extends NamedElement
implements IWorkspaceSettingsElement {
    private String m_interpreterPath;
    private int m_majorVersion;
    private String m_pythonPathString;
    private List<String> m_pythonPaths = new ArrayList<String>(2);
    private Set<String> m_keywords = new HashSet<String>();
    private List<String> m_builtinModules = new ArrayList<String>();
    private TFile m_skeletonDir;
    private TFile m_pythonUserHome;

    public PythonInterpreter(NamedElement parent) {
        super(parent);
    }

    public PythonInterpreter(NamedElement parent, String interpreterPath) {
        super(parent);
        assert (interpreterPath != null) : "Parameter 'interpreterPath' of method 'PythonInterpreterRecord' must not be null";
        this.m_interpreterPath = interpreterPath;
    }

    public String getShortName() {
        return this.m_interpreterPath;
    }

    public String getInterpreterPath() {
        return this.m_interpreterPath;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_interpreterPath);
        writer.writeInt(this.m_majorVersion);
        writer.writeString(this.m_pythonPathString);
        writer.writeString(this.concatenate(this.m_pythonPaths));
        writer.writeString(this.concatenate(this.m_keywords));
        writer.writeString(this.concatenate(this.m_builtinModules));
        writer.writeString(this.m_skeletonDir.getNormalizedAbsolutePath());
        writer.writeString(this.m_pythonUserHome.getNormalizedAbsolutePath());
    }

    private String concatenate(Collection<String> strings) {
        assert (strings != null) : "Parameter 'strings' of method 'concatenate' must not be null";
        return strings.stream().map(k -> k.trim()).filter(k -> k.length() > 0).collect(Collectors.joining(";"));
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_interpreterPath = reader.readString();
        this.m_majorVersion = reader.readInt();
        this.m_pythonPathString = reader.readString();
        this.collect(reader.readString(), this.m_pythonPaths);
        this.collect(reader.readString(), this.m_keywords);
        this.collect(reader.readString(), this.m_builtinModules);
        this.m_skeletonDir = new TFile(reader.readString());
        this.m_pythonUserHome = new TFile(reader.readString());
    }

    private void collect(String input, Collection<String> collector) {
        assert (input != null) : "Parameter 'input' of method 'collectStrings' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectStrings' must not be null";
        String[] stringArray = input.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            String trimmed = next.trim();
            if (trimmed.length() > 0) {
                collector.add(trimmed);
            }
            ++n2;
        }
    }

    public void setSkeletonDir(TFile skeletonDir) {
        assert (skeletonDir != null) : "Parameter 'skeletonDir' of method 'setSkeletonDir' must not be null";
        this.m_skeletonDir = skeletonDir;
    }

    public TFile getSkeletonDir() {
        return this.m_skeletonDir;
    }

    public void setPythonUserHome(TFile pythonUserHome) {
        assert (pythonUserHome != null) : "Parameter 'pythonUserHome' of method 'setPythonUserHome' must not be null";
        this.m_pythonUserHome = pythonUserHome;
    }

    public TFile getPythonUserHome() {
        return this.m_pythonUserHome;
    }

    public void setMajorVersion(int majorVersion) {
        this.m_majorVersion = majorVersion;
    }

    public int getMajorVersion() {
        return this.m_majorVersion;
    }

    public void setPythonPathString(String pythonPathString) {
        assert (pythonPathString != null) : "Parameter 'pythonPathString' of method 'setPythonPathString' must not be null";
        this.m_pythonPathString = pythonPathString;
    }

    public String getPythonPathString() {
        return this.m_pythonPathString;
    }

    public void setPythonPaths(List<String> pythonPath) {
        assert (pythonPath != null) : "Parameter 'pythonPath' of method 'setPythonPath' must not be null";
        this.m_pythonPaths = pythonPath;
    }

    public void addPythonPath(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'addPythonPath' must not be empty";
        this.m_pythonPaths.add(path);
    }

    public List<String> getPythonPaths() {
        return this.m_pythonPaths;
    }

    public void setKeywords(Set<String> keywords) {
        assert (keywords != null) : "Parameter 'keywords' of method 'setKeywords' must not be null";
        this.m_keywords = keywords;
    }

    public Set<String> getKeywords() {
        return this.m_keywords;
    }

    public void setBuiltinModules(List<String> builtinModules) {
        assert (builtinModules != null) : "Parameter 'builtinModules' of method 'setBuiltinModules' must not be null";
        this.m_builtinModules = builtinModules;
    }

    public boolean isBuiltinModuleName(String name) {
        return Collections.binarySearch(this.m_builtinModules, name) >= 0;
    }

    public PythonInterpreter copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        PythonInterpreter copy = new PythonInterpreter(parent, this.m_interpreterPath);
        copy.m_majorVersion = this.m_majorVersion;
        copy.m_pythonUserHome = this.m_pythonUserHome;
        copy.m_skeletonDir = this.m_skeletonDir;
        copy.m_pythonPathString = this.m_pythonPathString;
        copy.m_builtinModules = new ArrayList<String>(this.m_builtinModules);
        copy.m_keywords = new HashSet<String>(this.m_keywords);
        copy.m_pythonPaths = new ArrayList<String>(this.m_pythonPaths);
        return copy;
    }
}

