/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.model.programming;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonDependencyType;
import java.io.IOException;

public class PythonDependency
extends ParserDependency {
    private PythonDependencyType m_type;
    private int m_line;

    public PythonDependency(ProgrammingElement from) {
        super(from);
    }

    public PythonDependency(ProgrammingElement from, ProgrammingElement to, PythonDependencyType type, int line) {
        super(from, to);
        assert (type != null) : "Parameter 'type' of method 'PythonDependency' must not be null";
        this.m_type = type;
        this.m_line = line;
    }

    public IParserDependencyType getDependencyType() {
        return this.m_type;
    }

    public int getLineNumber() {
        return this.m_line <= 0 ? super.getLineNumber() : this.m_line;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_type.name());
        writer.writeInt(this.m_line);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        String typeId = reader.readString();
        this.m_type = PythonDependencyType.valueOf(typeId);
        assert (this.m_type != null);
        this.m_line = reader.readInt();
    }
}

