/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.PythonInterpreterCreator;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreter;
import de.schlichtherle.truezip.file.TFile;

final class PythonInterpreterValidator
implements IPathValidator {
    public IPathValidator.PathType getType() {
        return IPathValidator.PathType.FILE;
    }

    public ValidationResult isValid(TFile currentInput, TFile newInput) {
        ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
        if (newInput == null || newInput.getPath().isEmpty()) {
            result.addError("Must not be empty");
            return result;
        }
        if (!newInput.isFile()) {
            result.addError("Specified path '" + newInput.getNormalizedAbsolutePath() + "' is not a file.");
            return result;
        }
        if (!newInput.canExecute()) {
            result.addError("Specified path '" + newInput.getNormalizedAbsolutePath() + "' is not executable.");
            return result;
        }
        PythonInterpreterCreator creator = new PythonInterpreterCreator();
        OperationResultWithOutcome<PythonInterpreter> creationResult = creator.create(null, newInput.getNormalizedAbsolutePath());
        if (creationResult.isFailure()) {
            result.addError("Selected file is not a valid Python interpreter");
            return result;
        }
        if (((PythonInterpreter)((Object)creationResult.getOutcome())).getMajorVersion() < 3) {
            result.addError("Interpreter must support Python 3 or higher");
            return result;
        }
        return result;
    }
}

