/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.command.system;

import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.ICSharpWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.ProjectInfo;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.settings.CSharpSolutionFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.settings.CSharpSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpRoslynModule;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class CSharpSolutionImportData {
    private TFile m_solutionFile;
    private List<ProjectInfo> m_projectsToImport;
    private Set<String> m_originalModules = new THashSet();

    public CSharpSolutionImportData(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'CSharpSolutionImportData' must not be null";
        Workspace ws = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        CSharpSystemSettings settings = (CSharpSystemSettings)((Object)ws.getUniqueChild(CSharpSystemSettings.class));
        if (settings == null) {
            this.m_solutionFile = null;
            this.m_projectsToImport = Collections.emptyList();
            this.m_originalModules = Collections.emptySet();
        } else {
            this.m_solutionFile = ((CSharpSolutionFile)((Object)settings.getUniqueExistingChild(CSharpSolutionFile.class))).getFile();
            this.m_projectsToImport = ((ICSharpWorkspaceExtension)softwareSystem.getExtension(ICSharpWorkspaceExtension.class)).getProjectsFromSolution();
            for (CSharpRoslynModule module : ws.getChildren(CSharpRoslynModule.class)) {
                this.m_originalModules.add(module.getProjectName());
            }
        }
    }

    public CSharpSolutionImportData() {
    }

    public void setSolutionFileInfo(TFile solutionFile) {
        this.m_solutionFile = solutionFile;
    }

    public TFile getSolutionFile() {
        return this.m_solutionFile;
    }

    public List<ProjectInfo> getProjectsToImport() {
        return this.m_projectsToImport;
    }

    public void setProjectsToImport(List<ProjectInfo> projectsToImport) {
        this.m_projectsToImport = projectsToImport;
    }

    public Set<String> getOrignalModules() {
        return this.m_originalModules;
    }
}

