/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.architecture.model;

import com.hello2morrow.sonargraph.integration.architecture.model.ArchitectureElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class Interface
extends ArchitectureElement {
    private final ArchitectureElement parent;
    private final boolean isOptional;
    private final EnumSet<DependencyType> allowedDependencyTypes;
    private final List<Interface> exportedInterfaces = new ArrayList<Interface>();

    public Interface(ArchitectureElement parent, String name, boolean isOptional, EnumSet<DependencyType> allowedDependencyTypes) {
        super(name);
        assert (parent != null);
        this.parent = parent;
        this.isOptional = isOptional;
        this.allowedDependencyTypes = allowedDependencyTypes;
    }

    public boolean isRestricted() {
        return this.allowedDependencyTypes != null;
    }

    public Set<DependencyType> getAllowedDependencyTypes() {
        if (this.isRestricted()) {
            return Collections.unmodifiableSet(this.allowedDependencyTypes);
        }
        return EnumSet.allOf(DependencyType.class);
    }

    public void addExportedInterface(Interface iface) {
        assert (iface != null);
        this.exportedInterfaces.add(iface);
    }

    public List<Interface> getExportedInterfaces() {
        return Collections.unmodifiableList(this.exportedInterfaces);
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public ArchitectureElement getParent() {
        return this.parent;
    }

    public static enum DependencyType {
        CALL,
        EXTENDS,
        IMPLEMENTS,
        READ,
        WRITE,
        USES,
        NEW;

    }
}

