/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.apitest;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.TestUtility;
import com.hello2morrow.sonargraph.integration.access.model.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.integration.access.model.IAnalyzer;
import com.hello2morrow.sonargraph.integration.access.model.IComponentFilter;
import com.hello2morrow.sonargraph.integration.access.model.ICycleGroupIssue;
import com.hello2morrow.sonargraph.integration.access.model.IDeleteRefactoring;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyPattern;
import com.hello2morrow.sonargraph.integration.access.model.IElementPattern;
import com.hello2morrow.sonargraph.integration.access.model.IFilter;
import com.hello2morrow.sonargraph.integration.access.model.IIgnoreDefinition;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IMatching;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricValue;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.IMoveRefactoring;
import com.hello2morrow.sonargraph.integration.access.model.IMoveRenameRefactoring;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IPlugin;
import com.hello2morrow.sonargraph.integration.access.model.IRenameRefactoring;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFile;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFileElement;
import com.hello2morrow.sonargraph.integration.access.model.IToDoDefinition;
import com.hello2morrow.sonargraph.integration.access.model.IWildcardPattern;
import com.hello2morrow.sonargraph.integration.access.model.PluginExecutionPhase;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import com.hello2morrow.sonargraph.integration.access.model.SystemFileType;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.PluginExternalImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.ProgrammingElementImpl;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public final class ReportReaderTest {
    @Test
    public void processReportWithCycleGroup() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/IntegrationAccess_WithCycleGroup.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISystemInfoProcessor info = controller.createSystemInfoProcessor();
        Assert.assertEquals((String)"Wrong number of issues", (long)11L, (long)info.getIssues(null).size());
    }

    @Test
    public void processReportWithNoIssues() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/ReportWithoutIssues.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISystemInfoProcessor info = controller.createSystemInfoProcessor();
        Assert.assertEquals((String)"Wrong number of issues", (long)0L, (long)info.getIssues(null).size());
    }

    @Test
    public void processReportWithoutElements() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/ReportWithoutElements.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        Assert.assertEquals((String)"Wrong number of modules", (long)1L, (long)controller.getSoftwareSystem().getModules().size());
    }

    @Test
    public void processReportCreatedWith9_3() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClock_9.3.0.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        Assert.assertEquals((String)"Wrong number of modules", (long)4L, (long)controller.getSoftwareSystem().getModules().size());
    }

    private Predicate<IIssue> createUnresolvedIssueFilter(String categoryPresentationName) {
        return i -> !i.hasResolution() && i.getIssueType().getCategory().getPresentationName().equals(categoryPresentationName);
    }

    @Test
    public void processCSharpReport() throws Exception {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/NHibernate_2017-04-03_11-59-50.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        Assert.assertEquals((String)"Wrong number of modules", (long)4L, (long)controller.getSoftwareSystem().getModules().size());
        ISystemInfoProcessor info = controller.createSystemInfoProcessor();
        Assert.assertEquals((String)"Wrong number of cycle issues", (long)86L, (long)info.getIssues(this.createUnresolvedIssueFilter("Cycle Group")).size());
        Assert.assertEquals((String)"Wrong number of duplicates", (long)200L, (long)info.getIssues(this.createUnresolvedIssueFilter("Duplicate Code")).size());
        Assert.assertEquals((String)"Wrong number of script based issues", (long)109L, (long)info.getIssues(this.createUnresolvedIssueFilter("Script Based")).size());
        Assert.assertEquals((String)"Wrong number of threshold violations", (long)47L, (long)info.getIssues(this.createUnresolvedIssueFilter("Threshold Violation")).size());
        Assert.assertEquals((String)"Wrong number of workspace issues", (long)1L, (long)info.getIssues(this.createUnresolvedIssueFilter("Workspace")).size());
        Assert.assertEquals((String)"Wrong number of resolutions", (long)1L, (long)info.getResolutions(r -> r.getType() == ResolutionType.TODO).size());
        IModule nhibernate = controller.getSoftwareSystem().getModule("NHibernate").orElseThrow(() -> new Exception("Module NHibernate not found"));
        IModuleInfoProcessor moduleProcessor = controller.createModuleInfoProcessor(nhibernate);
        Assert.assertEquals((String)"Wrong number of namespace cycle groups", (long)2L, (long)moduleProcessor.getIssues(i -> i.getIssueType().getPresentationName().equals("Namespace Cycle Group")).size());
    }

    @Test
    public void processCppReport() throws Exception {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/project_2_2017-04-03_14-54-53.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        Assert.assertEquals((String)"Wrong number of modules", (long)1L, (long)controller.getSoftwareSystem().getModules().size());
        ISystemInfoProcessor info = controller.createSystemInfoProcessor();
        Assert.assertEquals((String)"Wrong number of cycle issues", (long)5L, (long)info.getIssues(this.createUnresolvedIssueFilter("Cycle Group")).size());
        Assert.assertEquals((String)"Wrong number of duplicates", (long)4L, (long)info.getIssues(this.createUnresolvedIssueFilter("Duplicate Code")).size());
        Assert.assertEquals((String)"Wrong number of 'no definition found'", (long)22L, (long)info.getIssues(i -> i.getIssueType().getPresentationName().equals("No definition found")).size());
        Assert.assertEquals((String)"Wrong number of workspace issues", (long)22L, (long)info.getIssues(this.createUnresolvedIssueFilter("Workspace")).size());
        IModule generic = controller.getSoftwareSystem().getModule("Generic").orElseThrow(() -> new Exception("Module 'Generic' not found"));
        Map<String, INamedElement> cppMemberFunctions = TestUtility.getFqNameToNamedElement(generic, "CppMemberFunction");
        Assert.assertTrue((String)"no elements found", (cppMemberFunctions.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Logical element not found", (Object)cppMemberFunctions.get("Workspace:Generic:./src:kernel:gsingltn:(header)./src/../include/gsingltn.h:class G_Singleton<T1>:G_Singleton(const char*, const char*)"));
        IModuleInfoProcessor moduleInfoProcessor = controller.createModuleInfoProcessor(generic);
        IMetricLevel level = moduleInfoProcessor.getMetricLevel("Routine").get();
        IMetricId metricId = moduleInfoProcessor.getMetricId(level, "CoreParameters").get();
        IMetricValue value = moduleInfoProcessor.getMetricValueForElement(metricId, level, "Workspace:Generic:./src:kernel:gsingltn:(header)./src/../include/gsingltn.h:class G_Singleton<T1>:G_Singleton(const char*, const char*)").get();
        Assert.assertEquals((String)"Wrong metric value", (long)2L, (long)value.getValue().intValue());
    }

    @Test
    public void processCppReportWithLogicalNamespaces() throws Exception {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/Hilo_2017-04-03_19-08-39.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        Assert.assertEquals((String)"Wrong number of modules", (long)4L, (long)controller.getSoftwareSystem().getModules().size());
        ISystemInfoProcessor info = controller.createSystemInfoProcessor();
        Assert.assertEquals((String)"Wrong number of duplicates", (long)4L, (long)info.getIssues(this.createUnresolvedIssueFilter("Duplicate Code")).size());
        Assert.assertEquals((String)"Wrong number of 'no definition found'", (long)5L, (long)info.getIssues(i -> i.getIssueType().getPresentationName().equals("No definition found")).size());
        Assert.assertEquals((String)"Wrong number of workspace issues", (long)7L, (long)info.getIssues(this.createUnresolvedIssueFilter("Workspace")).size());
        IModule browser = controller.getSoftwareSystem().getModule("Browser").orElseThrow(() -> new Exception("Module 'Browser' not found"));
        Map<String, INamedElement> cppNamespaces = TestUtility.getFqNameToNamedElement(browser, "CPlusPlusLogicalModuleNamespace");
        Assert.assertTrue((String)"no elements found", (cppNamespaces.size() > 0 ? 1 : 0) != 0);
        IModuleInfoProcessor moduleInfoProcessor = controller.createModuleInfoProcessor(browser);
        IMetricLevel level = moduleInfoProcessor.getMetricLevel("CppNamespace").orElseThrow(() -> new Exception("Metric level not found"));
        IMetricId metricId = moduleInfoProcessor.getMetricId(level, "CoreTypesModule").orElseThrow(() -> new Exception("Metric not found"));
        Assert.assertEquals((String)"Wrong number of types for module namespace", (long)22L, (long)moduleInfoProcessor.getMetricValueForElement(metricId, level, "Logical module namespaces:Browser:Hilo:AsyncLoader").get().getValue().intValue());
    }

    @Test
    public void processClassFileIssuesReport() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClock_ClassFileIssues.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
    }

    @Test
    public void testReportStandard() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/ReportStandard.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
    }

    @Test
    public void testDirectoryIssues() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/ReportWithDerived.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        Assert.assertEquals((String)"Wrong number of modules", (long)2L, (long)controller.getSoftwareSystem().getModules().size());
        HashMap<String, Map<String, List<IIssue>>> moduleToIssues = new HashMap<String, Map<String, List<IIssue>>>();
        ISystemInfoProcessor systemInfoProcessor = controller.createSystemInfoProcessor();
        for (IModule nextModule : systemInfoProcessor.getModules().values()) {
            IModuleInfoProcessor nextModuleInfoProcessor = controller.createModuleInfoProcessor(nextModule);
            Map<String, List<IIssue>> issueMap = nextModuleInfoProcessor.getIssuesForDirectories(issue -> !issue.isIgnored() && !"Workspace".equals(issue.getIssueType().getCategory().getName()));
            moduleToIssues.put(nextModule.getName(), issueMap);
        }
        Map m1IssueMap = (Map)moduleToIssues.get("M1");
        Assert.assertNotNull((String)"Module M1 not found", (Object)m1IssueMap);
        Assert.assertTrue((String)"3 directories with issues expected for module M1", (m1IssueMap.size() == 3 ? 1 : 0) != 0);
        Map m5IssueMap = (Map)moduleToIssues.get("M5");
        Assert.assertNotNull((String)"Module M5 not found", (Object)m5IssueMap);
        Assert.assertTrue((String)"1 directory with issue expected for module M5", (m5IssueMap.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReportWithPackageTodo() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/ReportWithPackageTodo.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        HashMap<IModuleInfoProcessor, Map<String, List<IIssue>>> moduleToIssues = new HashMap<IModuleInfoProcessor, Map<String, List<IIssue>>>();
        ISystemInfoProcessor systemInfoProcessor = controller.createSystemInfoProcessor();
        for (IModule iModule : systemInfoProcessor.getModules().values()) {
            IModuleInfoProcessor nextModuleInfoProcessor = controller.createModuleInfoProcessor(iModule);
            Map<String, List<IIssue>> issueMap = nextModuleInfoProcessor.getIssuesForDirectories(issue -> !issue.isIgnored() && !"Workspace".equals(issue.getIssueType().getCategory().getName()));
            moduleToIssues.put(nextModuleInfoProcessor, issueMap);
        }
        Assert.assertTrue((String)"1 module expected", (moduleToIssues.size() == 1 ? 1 : 0) != 0);
        for (Map.Entry entry : moduleToIssues.entrySet()) {
            Map issueMap = (Map)entry.getValue();
            Assert.assertTrue((String)"1 directory with issue expected", (issueMap.size() == 1 ? 1 : 0) != 0);
            for (Map.Entry nextIssueMapEntry : issueMap.entrySet()) {
                for (IIssue nextIssue : (List)nextIssueMapEntry.getValue()) {
                    IResolution nextResolution = ((IModuleInfoProcessor)entry.getKey()).getResolution(nextIssue);
                    Assert.assertNotNull((String)"Resolution expected", (Object)nextResolution);
                }
            }
        }
    }

    @Test
    public void checkForCycleMetrics() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClock_with_cycle_metrics.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISystemInfoProcessor infoProcessor = controller.createSystemInfoProcessor();
        List<ICycleGroupIssue> packageCycles = this.getCycleGroup(infoProcessor, "NamespaceCycleGroup");
        Assert.assertEquals((String)"Wrong number of package cycles ", (long)1L, (long)packageCycles.size());
        ICycleGroupIssue packageCycle = packageCycles.get(0);
        Assert.assertEquals((String)"Wrong number of cyclic elements", (long)2L, (long)packageCycle.getAffectedNamedElements().size());
        Assert.assertEquals((String)"Wrong structural debt index", (long)13L, (long)packageCycle.getStructuralDebtIndex());
        Assert.assertEquals((String)"Wrong component dependencies to remove", (long)1L, (long)packageCycle.getComponentDependenciesToRemove());
        Assert.assertEquals((String)"Wrong parser dependencies to remove", (long)3L, (long)packageCycle.getParserDependenciesToRemove());
        List<ICycleGroupIssue> componentCycles = this.getCycleGroup(infoProcessor, "ComponentCycleGroup");
        Assert.assertEquals((String)"Wrong number of component cycles ", (long)1L, (long)componentCycles.size());
        ICycleGroupIssue componentCycle = componentCycles.get(0);
        Assert.assertEquals((String)"Wrong number of cyclic elements", (long)2L, (long)componentCycle.getAffectedNamedElements().size());
        Assert.assertEquals((String)"Wrong structural debt index", (long)13L, (long)componentCycle.getStructuralDebtIndex());
        Assert.assertEquals((String)"Wrong component dependencies to remove", (long)1L, (long)componentCycle.getComponentDependenciesToRemove());
        Assert.assertEquals((String)"Wrong parser dependencies to remove", (long)3L, (long)componentCycle.getParserDependenciesToRemove());
    }

    private List<ICycleGroupIssue> getCycleGroup(ISystemInfoProcessor infoProcessor, String issueTypeName) {
        return infoProcessor.getIssues(i -> i.getIssueType().getName().equals(issueTypeName)).stream().map(i -> (ICycleGroupIssue)i).collect(Collectors.toList());
    }

    @Test
    public void processReportWithPluginInfoAndAnalyzerExecutionLevel() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClock_with_plugins.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISystemInfoProcessor systemInfoProcessor = controller.createSystemInfoProcessor();
        ISoftwareSystem softwareSystem = systemInfoProcessor.getSoftwareSystem();
        Map<String, IPlugin> plugins = softwareSystem.getPlugins();
        Assert.assertEquals((String)"Wrong number of plugins", (long)2L, (long)plugins.size());
        IPlugin swagger = plugins.get("SwaggerPlugin");
        Assert.assertNotNull((String)"Swagger plugin not found", (Object)swagger);
        Assert.assertEquals((String)"Wrong name", (Object)"SwaggerPlugin", (Object)swagger.getName());
        Assert.assertEquals((String)"Wrong presentation name", (Object)"Swagger Plugin", (Object)swagger.getPresentationName());
        Assert.assertEquals((String)"Wrong description", (Object)"Plugin that exposes webresources and dependencies between them.", (Object)swagger.getDescription());
        Assert.assertEquals((String)"Wrong version", (Object)"9.9.2.533_2018-12-12", (Object)swagger.getVersion());
        Assert.assertEquals((String)"Wrong vendor", (Object)"hello2morrow GmbH", (Object)swagger.getVendor());
        Assert.assertFalse((String)"Must not be enabled", (boolean)swagger.isEnabled());
        Assert.assertTrue((String)"Must not be executed", (boolean)swagger.getActiveExecutionPhases().isEmpty());
        Assert.assertEquals((String)"Wrong type of available execution phase", EnumSet.of(PluginExecutionPhase.MODEL), swagger.getSupportedExecutionPhases());
        Assert.assertTrue((String)"Must be licensed", (boolean)swagger.isLicensed());
        IPlugin spotbugsPlugin = plugins.get("SpotbugsPlugin");
        Assert.assertNotNull((String)"Spotbugs plugin not found", (Object)spotbugsPlugin);
        Assert.assertEquals((String)"Wrong type of available execution phases", EnumSet.of(PluginExecutionPhase.ANALYZER), spotbugsPlugin.getSupportedExecutionPhases());
        Assert.assertEquals((String)"Wrong analyzer execution level", (Object)AnalyzerExecutionLevel.ADVANCED, (Object)systemInfoProcessor.getSoftwareSystem().getAnalyzerExecutionLevel());
        Map<String, IAnalyzer> analyzers = softwareSystem.getAnalyzers();
        IAnalyzer spotbugs = analyzers.get("SpotbugsPlugin");
        Assert.assertNotNull((String)"Spotbugs analyzer must exist", (Object)spotbugs);
        Assert.assertTrue((String)"Must be licensed", (boolean)spotbugs.isLicensed());
        Assert.assertFalse((String)"Must not be executed", (boolean)spotbugs.isExecuted());
    }

    @Test
    public void processWorkspaceFilters() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClock_with_workspace_filters.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISystemInfoProcessor systemInfoProcessor = controller.createSystemInfoProcessor();
        ISoftwareSystem softwareSystem = systemInfoProcessor.getSoftwareSystem();
        Optional<IFilter> workspaceFilterOpt = softwareSystem.getWorkspaceFilter();
        Assert.assertTrue((String)"Workspace filter must exist", (boolean)workspaceFilterOpt.isPresent());
        IFilter workspaceFilter = workspaceFilterOpt.get();
        Assert.assertEquals((String)"Wrong description", (Object)"Exclude files from the workspace", (Object)workspaceFilter.getDescription());
        Assert.assertEquals((String)"Wrong information", (Object)"Excluded 0 files(s)", (Object)workspaceFilter.getInformation());
        Assert.assertEquals((String)"Wrong number of excluded elements", (long)0L, (long)workspaceFilter.getNumberOfExcludedElements());
        List<IWildcardPattern> includePatterns = workspaceFilter.getIncludePatterns();
        Assert.assertEquals((String)"Wrong number of include patterns", (long)1L, (long)includePatterns.size());
        IWildcardPattern include = includePatterns.get(0);
        Assert.assertEquals((String)"Wrong pattern", (Object)"**", (Object)include.getPattern());
        Assert.assertEquals((String)"Wrong number of matched elements", (long)21L, (long)include.getNumberOfMatches());
        List<IWildcardPattern> excludePatterns = workspaceFilter.getExcludePatterns();
        Assert.assertEquals((String)"Wrong number of exclude patterns", (long)1L, (long)excludePatterns.size());
        IWildcardPattern exclude = excludePatterns.get(0);
        Assert.assertEquals((String)"Wrong pattern", (Object)"**/bla/**", (Object)exclude.getPattern());
        Assert.assertEquals((String)"Wrong number of matched elements", (long)0L, (long)exclude.getNumberOfMatches());
        Optional<IComponentFilter> productionCodeFilterOpt = softwareSystem.getProductionCodeFilter();
        Assert.assertTrue((String)"Production code filter must exist", (boolean)productionCodeFilterOpt.isPresent());
        IComponentFilter productionCodeFilter = productionCodeFilterOpt.get();
        Assert.assertEquals((String)"Wrong description", (Object)"Exclude internal components containing test code", (Object)productionCodeFilter.getDescription());
        Assert.assertEquals((String)"Wrong information", (Object)"Excluded 1 internal component(s) (processed 10)", (Object)productionCodeFilter.getInformation());
        Assert.assertEquals((String)"Wrong number of included elements", (long)9L, (long)productionCodeFilter.getNumberOfIncludedElements());
        Assert.assertEquals((String)"Wrong number of excluded elements", (long)1L, (long)productionCodeFilter.getNumberOfExcludedElements());
        includePatterns = productionCodeFilter.getIncludePatterns();
        Assert.assertEquals((String)"Wrong number of include patterns", (long)1L, (long)includePatterns.size());
        include = includePatterns.get(0);
        Assert.assertEquals((String)"Wrong pattern", (Object)"**", (Object)include.getPattern());
        Assert.assertEquals((String)"Wrong number of matched elements", (long)10L, (long)include.getNumberOfMatches());
        excludePatterns = productionCodeFilter.getExcludePatterns();
        Assert.assertEquals((String)"Wrong number of exclude patterns", (long)1L, (long)excludePatterns.size());
        exclude = excludePatterns.get(0);
        Assert.assertEquals((String)"Wrong number of matched elements", (long)1L, (long)exclude.getNumberOfMatches());
        Assert.assertEquals((String)"Wrong pattern", (Object)"**/test/java/**1", (Object)exclude.getPattern());
        Optional<IComponentFilter> issueFilterOpt = softwareSystem.getIssueFilter();
        Assert.assertTrue((String)"Issue filter must exist", (boolean)issueFilterOpt.isPresent());
        IComponentFilter issueFilter = issueFilterOpt.get();
        Assert.assertEquals((String)"Wrong description", (Object)"Ignore analysis issues of internal components containing legacy/generated code", (Object)issueFilter.getDescription());
        Assert.assertEquals((String)"Wrong information", (Object)"Ignoring analysis issues of 2 internal component(s) (processed 9)", (Object)issueFilter.getInformation());
        Assert.assertEquals((String)"Wrong number of included elements", (long)7L, (long)issueFilter.getNumberOfIncludedElements());
        Assert.assertEquals((String)"Wrong number of excluded elements", (long)2L, (long)issueFilter.getNumberOfExcludedElements());
        includePatterns = issueFilter.getIncludePatterns();
        Assert.assertEquals((String)"Wrong number of include patterns", (long)1L, (long)includePatterns.size());
        include = includePatterns.get(0);
        Assert.assertEquals((String)"Wrong pattern", (Object)"**/*", (Object)include.getPattern());
        Assert.assertEquals((String)"Wrong number of matched elements", (long)9L, (long)include.getNumberOfMatches());
        excludePatterns = issueFilter.getExcludePatterns();
        Assert.assertEquals((String)"Wrong number of exclude patterns", (long)1L, (long)excludePatterns.size());
        exclude = excludePatterns.get(0);
        Assert.assertEquals((String)"Wrong number of matched elements", (long)2L, (long)exclude.getNumberOfMatches());
        Assert.assertEquals((String)"Wrong pattern", (Object)"**/test/java/**", (Object)exclude.getPattern());
    }

    @Test
    public void processSystemMetaData() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClock_with_metadata.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Assert.assertNotNull((String)"Missing softwareSystem", (Object)softwareSystem);
        Map<String, String> metaData = softwareSystem.getMetaData();
        Assert.assertEquals((String)"Wrong value", (Object)"hello2morrow", (Object)metaData.get("organisation"));
    }

    @Test
    public void processMetricMinMaxInformation() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClock_with_metric_metadata.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Assert.assertNotNull((String)"Missing softwareSystem", (Object)softwareSystem);
        ISystemInfoProcessor systemProcessor = controller.createSystemInfoProcessor();
        List<IMetricId> metricIds = systemProcessor.getMetricIds();
        Assert.assertEquals((String)"Wrong number of metrics", (long)95L, (long)metricIds.size());
        this.validateMetricInfo(systemProcessor, "CoreAcd", 0.0, Double.POSITIVE_INFINITY, IMetricId.SortDirection.HIGHER_WORSE);
        this.validateMetricInfo(systemProcessor, "JavaCyclicityPackages", 0.0, Double.POSITIVE_INFINITY, IMetricId.SortDirection.HIGHER_WORSE);
        IMetricId distance = this.validateMetricInfo(systemProcessor, "CoreDistanceSystem", -1.0, 1.0, IMetricId.SortDirection.OPTIMUM_AT_ZERO);
        Assert.assertEquals((String)"Wrong best value", (double)0.0, (double)distance.getBest(), (double)0.001);
        this.validateMetricInfo(systemProcessor, "CoreLinesOfCode", 0.0, Double.POSITIVE_INFINITY, IMetricId.SortDirection.INDIFFERENT);
    }

    @Test
    public void processReportWithPluginExternalIssues() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/SwaggerTestProject.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Assert.assertNotNull((String)"Missing softwareSystem", (Object)softwareSystem);
        ISystemInfoProcessor systemProcessor = controller.createSystemInfoProcessor();
        List<IResolution> todos = systemProcessor.getResolutions(r -> r.getType() == ResolutionType.TODO);
        Assert.assertEquals((String)"Wrong number of todos", (long)3L, (long)todos.size());
        int index = 0;
        this.assertExternalTodo(todos.get(index++), "Swagger Todo", ProgrammingElementImpl.class, "Workspace:External [com.hello2morrow.sonargraph.plugin.swagger]:/pet/{petId}[DELETE]");
        this.assertExternalTodo(todos.get(index++), "Plugin External Todo", PluginExternalImpl.class, "Workspace:External [com.hello2morrow.sonargraph.plugin.swagger]");
        this.assertExternalTodo(todos.get(index), "TODO on Java External", NamedElementImpl.class, "Workspace:External [Java]:[Unknown]:java:io:File");
    }

    @Test
    public void processReportWithResolutionPatterns() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/ResolutionsWithPatterns.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Assert.assertNotNull((String)"Missing softwareSystem", (Object)softwareSystem);
        ISystemInfoProcessor systemProcessor = controller.createSystemInfoProcessor();
        List<IResolution> ignores = systemProcessor.getResolutions(r -> r.getType() == ResolutionType.IGNORE);
        Assert.assertEquals((String)"Wrong number of ignores", (long)9L, (long)ignores.size());
        IResolution ignoreArchViolations = ignores.get(0);
        Assert.assertEquals((String)"Wrong description", (Object)"C11 -> C22", (Object)ignoreArchViolations.getDescription());
        List<IDependencyPattern> dependencyPatterns = ignoreArchViolations.getDependencyPatterns();
        Assert.assertEquals((String)"Wrong number of dependency patterns", (long)4L, (long)dependencyPatterns.size());
        IResolution ignoreFixme = ignores.get(1);
        Assert.assertEquals((String)"Wrong description", (Object)"Only present in baseline", (Object)ignoreFixme.getDescription());
        List<IElementPattern> elementPatterns = ignoreFixme.getElementPatterns();
        Assert.assertEquals((String)"Wrong number of element patterns", (long)1L, (long)elementPatterns.size());
        IResolution ignoreCycle = ignores.get(5);
        Assert.assertEquals((String)"Wrong description", (Object)"Unmodified", (Object)ignoreCycle.getDescription());
        IMatching matching = ignoreCycle.getMatching();
        Assert.assertNotNull((String)"Matching missing", (Object)matching);
        List<IElementPattern> elementPatterns2 = matching.getPatterns();
        Assert.assertEquals((String)"Wrong number of matching patterns", (long)2L, (long)elementPatterns2.size());
    }

    @Test
    public void processReportWithResolutionTypes() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/ResolutionTypes.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Assert.assertNotNull((String)"Missing softwareSystem", (Object)softwareSystem);
        ISystemInfoProcessor systemProcessor = controller.createSystemInfoProcessor();
        List<IResolution> resolutions = systemProcessor.getResolutions(null);
        Assert.assertEquals((String)"Wrong number of resolutions", (long)7L, (long)resolutions.size());
        List<IIgnoreDefinition> ignores = systemProcessor.getResolutions(null, IIgnoreDefinition.class);
        Assert.assertEquals((String)"Wrong number of ignore resolutions", (long)1L, (long)ignores.size());
        List<IToDoDefinition> todos = systemProcessor.getResolutions(null, IToDoDefinition.class);
        Assert.assertEquals((String)"Wrong number of todo resolutions", (long)1L, (long)todos.size());
        List<IDeleteRefactoring> deletes = systemProcessor.getResolutions(null, IDeleteRefactoring.class);
        Assert.assertEquals((String)"Wrong number of delete refactorings", (long)1L, (long)deletes.size());
        List<IRenameRefactoring> renames = systemProcessor.getResolutions(null, IRenameRefactoring.class);
        Assert.assertEquals((String)"Wrong number of rename refactorings", (long)1L, (long)renames.size());
        List<IMoveRefactoring> moves = systemProcessor.getResolutions(null, IMoveRefactoring.class);
        Assert.assertEquals((String)"Wrong number of move refactorings (move + move/rename)", (long)1L, (long)moves.size());
        List<IMoveRenameRefactoring> moveRename = systemProcessor.getResolutions(null, IMoveRenameRefactoring.class);
        Assert.assertEquals((String)"Wrong number of move/rename refactorings", (long)1L, (long)moveRename.size());
    }

    private void assertExternalTodo(IResolution todo, String description, Class<?> clazzOfAffectedElement, String fqNameOfAffectedElement) {
        Assert.assertEquals((String)"Wrong description", (Object)description, (Object)todo.getDescription());
        INamedElement affectedElement = todo.getIssues().get(0).getAffectedNamedElements().get(0);
        Assert.assertEquals((String)"Wrong fqName", (Object)fqNameOfAffectedElement, (Object)affectedElement.getFqName());
        Assert.assertEquals((String)"Wrong class", clazzOfAffectedElement, affectedElement.getClass());
    }

    private IMetricId validateMetricInfo(ISystemInfoProcessor systemProcessor, String metricId, double min, double max, IMetricId.SortDirection direction) {
        Optional<IMetricId> metricOptional = systemProcessor.getMetricId(metricId);
        Assert.assertTrue((String)("Missing metric '" + metricId + "'"), (boolean)metricOptional.isPresent());
        IMetricId metric = metricOptional.get();
        Assert.assertEquals((String)"Wrong minValue", (double)min, (double)metric.getMin(), (double)0.001);
        Assert.assertEquals((String)"Wrong maxValue", (double)max, (double)metric.getMax(), (double)0.001);
        Assert.assertEquals((String)"Wrong direction", (Object)direction, (Object)metric.getSortDirection());
        return metric;
    }

    @Test
    public void processArchitectureFiles() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClock_with_architecture.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Assert.assertNotNull((String)"Missing softwareSystem", (Object)softwareSystem);
        ISystemInfoProcessor systemProcessor = controller.createSystemInfoProcessor();
        List architectureFiles = systemProcessor.getSystemFiles().stream().filter(f -> f.getType() == SystemFileType.ARCHITECTURE).collect(Collectors.toList());
        Assert.assertEquals((String)"Wrong number of checked architecture files", (long)1L, (long)architectureFiles.size());
        ISystemFile architectureFile = (ISystemFile)architectureFiles.get(0);
        Assert.assertEquals((String)"Wrong path", (Object)"./arch1.arc", (Object)architectureFile.getPath());
        Assert.assertEquals((String)"Wrong type", (Object)SystemFileType.ARCHITECTURE, (Object)architectureFile.getType());
        Assert.assertEquals((String)"Wrong lastModified", (long)1580913201550L, (long)architectureFile.getLastModified());
        Assert.assertEquals((String)"Wrong hash", (Object)"34186e7369e51bd6e9dafd6fa9e7942a", (Object)architectureFile.getHash());
    }

    @Test
    public void processReportWithUnknownElement() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClock_with_unknown_elements.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Assert.assertNotNull((String)"Missing softwareSystem", (Object)softwareSystem);
        ISystemInfoProcessor systemProcessor = controller.createSystemInfoProcessor();
        List architectureFiles = systemProcessor.getSystemFiles().stream().filter(f -> f.getType() == SystemFileType.ARCHITECTURE).collect(Collectors.toList());
        Assert.assertEquals((String)"Wrong number of checked architecture files", (long)1L, (long)architectureFiles.size());
        ISystemFile architectureFile = (ISystemFile)architectureFiles.get(0);
        Assert.assertEquals((String)"Wrong path", (Object)"./arch1.arc", (Object)architectureFile.getPath());
        Assert.assertEquals((String)"Wrong type", (Object)SystemFileType.ARCHITECTURE, (Object)architectureFile.getType());
        Assert.assertEquals((String)"Wrong lastModified", (long)1580913201550L, (long)architectureFile.getLastModified());
        Assert.assertEquals((String)"Wrong hash", (Object)"34186e7369e51bd6e9dafd6fa9e7942a", (Object)architectureFile.getHash());
    }

    @Test
    public void processReportWithQualityGateIssues() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/Report_with_qualitygate_issues.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Assert.assertNotNull((String)"Missing softwareSystem", (Object)softwareSystem);
        ISystemInfoProcessor systemProcessor = controller.createSystemInfoProcessor();
        List<IIssue> qualityGateIssues = systemProcessor.getIssues(i -> i.getIssueType().getName().equals("QualityGateIssue"));
        Assert.assertEquals((String)"Wrong number of quality gate issues", (long)3L, (long)qualityGateIssues.size());
    }

    @Test
    public void processReportWithQualityGateElements() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/Report_with_qualitygate_elements.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Assert.assertNotNull((String)"Missing softwareSystem", (Object)softwareSystem);
        ISystemInfoProcessor systemProcessor = controller.createSystemInfoProcessor();
        List<ISystemFileElement> systemFiles = systemProcessor.getSystemFileElements();
        Assert.assertEquals((String)"Wrong number of system files", (long)2L, (long)systemFiles.size());
        List<IIssue> qualityGateIssues = systemProcessor.getIssues(i -> i.getIssueType().getName().equals("QualityGateIssue"));
        Assert.assertEquals((String)"Wrong number of quality gate issues", (long)1L, (long)qualityGateIssues.size());
    }
}

