/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.installation;

import com.hello2morrow.sonargraph.core.model.system.settings.IPreferencePersistence;
import com.hello2morrow.sonargraph.core.model.system.settings.InstallationSettings;
import com.hello2morrow.sonargraph.core.persistence.system.settings.SearchPathFilePersistence;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerDefinitionPersistence;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IPersistenceProviderFactory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.installation.CompilerDefinitionPersistenceProvider;
import de.schlichtherle.truezip.file.TFile;

public class PersistenceProviderFactory
implements IPersistenceProviderFactory {
    public static final PersistenceProviderFactory INSTANCE = new PersistenceProviderFactory();
    public static final String ACTIVE_COMPILER_DEFINITION_PROPERTY_KEY = "activeCompilerDefinition";
    public static final String SEARCH_PATH_PORPERTY_KEY = "searchPath";
    public static final String INST_SPECIFIC_COMPILER_DEFINITIONS_DIR = "installationSpecificCompilerDefinitionsDir";

    private PersistenceProviderFactory() {
    }

    @Override
    public IPreferencePersistence createPreferenceProvider(TFile preferenceFile) {
        assert (preferenceFile != null) : "Parameter 'preferenceFile' of method 'createPreferenceProvider' must not be null";
        return new SearchPathFilePersistence(preferenceFile, new String[]{SEARCH_PATH_PORPERTY_KEY, ACTIVE_COMPILER_DEFINITION_PROPERTY_KEY, INST_SPECIFIC_COMPILER_DEFINITIONS_DIR});
    }

    @Override
    public ICompilerDefinitionPersistence createCompilerDefinitionPersistence(InstallationSettings installationSettings) {
        assert (installationSettings != null) : "Parameter 'installationSettings' of method 'createCompilerDefinitionPersistence' must not be null";
        return new CompilerDefinitionPersistenceProvider(installationSettings);
    }
}

