/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusStructureItem;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceMember;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.NameHelper;
import java.io.IOException;

public final class CppEnumeration
extends ProgrammingElementWithChildren
implements IType,
ICppNamespaceComponent,
ICppNamespaceMember {
    private boolean m_residesInAnonymousNamespace = false;

    public CppEnumeration(NamedElement parent) {
        super(parent);
    }

    public CppEnumeration(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, boolean residesInAnonymousNamespace) {
        super(msp, parent, name, lineNumber);
        this.m_residesInAnonymousNamespace = residesInAnonymousNamespace;
    }

    @Override
    public boolean residesInAnonymousNamespace() {
        return this.m_residesInAnonymousNamespace;
    }

    public ProgrammingElement getOriginal() {
        return (ProgrammingElement)this.getOriginal(this.getModelServiceProvider());
    }

    public ProgrammingElement getRepresentative() {
        return (ProgrammingElement)this.getRepresentative(this.getModelServiceProvider());
    }

    @Override
    public boolean isDefinition() {
        return this.hasChildren();
    }

    @Override
    public ProgrammingElement getProgrammingElement() {
        return this;
    }

    public String getShortName() {
        String name = super.getShortName();
        if (name.startsWith("[anonymous]")) {
            return "[anonymous]";
        }
        return name;
    }

    public String getFullyQualifiedNamePart() {
        return "enum " + super.getShortName();
    }

    @Property
    public String getFullyQualifiedTypeName() {
        return this.getName().replace("::", ".");
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isMember() {
        return false;
    }

    @IntProperty
    public int getNumberOfMethods() {
        return 0;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isAnonymous() {
        return this.getShortName().startsWith("[anonymous]");
    }

    @Property
    public boolean isNested() {
        return this.getParent(ProgrammingElement.class, new Class[0]) != null;
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        if (reader.getVersion() <= 21) {
            reader.readBoolean();
        } else {
            this.m_residesInAnonymousNamespace = reader.readBoolean();
        }
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeBoolean(this.m_residesInAnonymousNamespace);
    }

    public String getName() {
        return NameHelper.getFullName((NamedElement)this);
    }

    public IStructureItem getStructureItem() {
        return CPlusPlusStructureItem.PROGRAMMING_ELEMENT;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppEnumeration(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppEnumeration(CppEnumeration var1);
    }
}

