/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFlags;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppSourceFileElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.IHasFullName;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import java.io.IOException;

public class CppProgrammingElement
extends CppElement
implements IHasFullName {
    public static final String ANONYMOUS_ELEMENT = "[anonymous]";
    public static final String NAMESPACE_SEP = "::";
    private static final String FLAGS = "flags";
    private static final String NAMESPACE = "namespace";
    private static final String LINE_NO = "lineNo";
    private static final String TYPE = "type";
    private CppElementType m_type;
    private int m_lineNo;
    private String m_namespace;
    private int m_flags;

    public CppProgrammingElement() {
    }

    public CppProgrammingElement(CppElement parent, CppElementType type, String name, int lineNo) {
        super(parent, name);
        assert (type != null) : "Parameter 'type' of method 'CppProgrammingElement' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'CppProgrammingElement' must not be null";
        this.m_type = type;
        this.m_lineNo = lineNo;
    }

    @Override
    public void addDependency(CppElement to, CppDependencyType type, int lineNo) {
        if (!this.isExternal() || type == CppDependencyType.DECLARES) {
            super.addDependency(to, type, lineNo);
        }
    }

    @Override
    public boolean isFunction() {
        return this.m_type.isFunction();
    }

    @Override
    public CppSourceFileElement getSource() {
        return this.getParent(CppSourceFileElement.class);
    }

    @Override
    public boolean isExternal() {
        return this.getSource().isExternal();
    }

    public boolean isRelevantDefinition() {
        return this.m_type != CppElementType.MACRO;
    }

    public boolean isDefinition() {
        return this.hasFlag(CppFlags.DEFINITION);
    }

    public boolean isDeclaration() {
        return this.hasFlag(CppFlags.DECLARATION);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeEnumConstant(TYPE, (Enum)this.m_type);
        writer.writeInt(LINE_NO, this.m_lineNo);
        writer.writeString(NAMESPACE, this.m_namespace);
        writer.writeInt(FLAGS, this.m_flags);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_type = (CppElementType)reader.readEnumConstant(TYPE, CppElementType.class);
        this.m_lineNo = reader.readInt(LINE_NO);
        this.m_namespace = reader.readString(NAMESPACE);
        this.m_flags = reader.readInt(FLAGS);
    }

    @Override
    public int getLineNo() {
        return this.m_lineNo;
    }

    public void addFlag(CppFlags flag) {
        assert (flag != null) : "Parameter 'flag' of method 'addFlag' must not be null";
        this.m_flags |= 1 << flag.ordinal();
    }

    public boolean hasFlag(CppFlags flag) {
        assert (flag != null) : "Parameter 'flag' of method 'addFlag' must not be null";
        return (this.m_flags & 1 << flag.ordinal()) != 0;
    }

    public void removeFlag(CppFlags flag) {
        assert (flag != null) : "Parameter 'flag' of method 'addFlag' must not be null";
        this.m_flags &= ~(1 << flag.ordinal());
    }

    public CppElementType getType() {
        return this.m_type;
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    public void setNamespace(String namespace, boolean anonymous) {
        this.m_namespace = namespace;
        if (anonymous) {
            this.addFlag(CppFlags.IN_ANONYMOUS_NAMESPACE);
        }
    }

    @Override
    public String getFullName() {
        CppElement parent = this.getParent();
        String name = this.getPresentationName();
        if (parent instanceof IHasFullName) {
            return ((IHasFullName)((Object)parent)).getFullName() + NAMESPACE_SEP + name;
        }
        if (this.m_namespace != null) {
            return this.m_namespace + NAMESPACE_SEP + name;
        }
        return name;
    }

    @Override
    public String getPresentationName() {
        String name = this.getName();
        if (name.startsWith(ANONYMOUS_ELEMENT)) {
            name = ANONYMOUS_ELEMENT;
        }
        return name;
    }

    @Override
    public String getKey() {
        return this.getFullName() + ":" + this.m_lineNo;
    }

    @Override
    public void accept(CppElement.Visitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)((Object)visitor)).visitCppProgrammingElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCppProgrammingElement(CppProgrammingElement var1);
    }
}

