/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser;

import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ErrorMessage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParsingResult {
    public static final int PARSER_CANCELLED = -7;
    public static final int PARSER_UNEXPECTED_TERMINATION = -6;
    public static final int PARSER_FAILED_TO_START = -5;
    public static final int PARSER_MODEL_CORRUPTED = -4;
    public static final int PARSER_CRASHED = -3;
    public static final int PARSER_EXITED_WITH_EXCEPTION = -2;
    public static final int PARSER_INTERNAL_ERROR = -1;
    public static final int PARSING_FAILED = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsingResult.class);
    private final CPlusPlusModule m_module;
    private final CppSourceFile m_sourceFile;
    private List<ErrorMessage> m_ErrorMessages = null;
    private final int m_Status;
    private boolean m_hasInternalError = false;
    private final CppCompilationUnit m_model;
    private String m_exceptionMessage = null;

    public ParsingResult() {
        this.m_Status = -7;
        this.m_module = null;
        this.m_sourceFile = null;
        this.m_model = null;
    }

    public ParsingResult(CPlusPlusModule module, CppSourceFile sourceFile, int status, String errorFileNameOrMsg, CppCompilationUnit model) {
        this.m_module = module;
        this.m_sourceFile = sourceFile;
        this.m_Status = status;
        this.m_model = model;
        if (status == -1) {
            this.m_ErrorMessages = new ArrayList<ErrorMessage>(1);
            this.m_ErrorMessages.add(new ErrorMessage("Catastrophic error: parsing request failed"));
        } else if (status == -2) {
            this.m_ErrorMessages = new ArrayList<ErrorMessage>(1);
            this.m_ErrorMessages.add(new ErrorMessage("Catastrophic error: parsing failed due to " + errorFileNameOrMsg));
            this.m_exceptionMessage = errorFileNameOrMsg;
        } else if (errorFileNameOrMsg == null) {
            this.m_ErrorMessages = new ArrayList<ErrorMessage>(1);
            this.m_ErrorMessages.add(new ErrorMessage("Catastrophic error: cannot create temporary file to capture edg diagnostic messages"));
        } else {
            TFile errorFile = new TFile(errorFileNameOrMsg);
            if (errorFile.canRead()) {
                if (status != 0) {
                    try {
                        Throwable throwable = null;
                        Object var8_11 = null;
                        try (BufferedReader reader = new BufferedReader(new FileReader((File)errorFile), 4096);){
                            String errorMsg;
                            while ((errorMsg = reader.readLine()) != null) {
                                if (!this.isRelevant(errorMsg)) continue;
                                this.addErrorMessage(new ErrorMessage(errorMsg));
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot read or open edg error message file", (Throwable)e);
                    }
                }
                try {
                    errorFile.rm();
                }
                catch (IOException e) {
                    LOGGER.error("Could not delete temporary error message file: " + errorFileNameOrMsg + " - ", (Throwable)e);
                }
            }
        }
    }

    public boolean isCancelled() {
        return this.m_Status == -7;
    }

    public void addErrorMessage(ErrorMessage msg) {
        if (this.m_ErrorMessages == null) {
            this.m_ErrorMessages = new ArrayList<ErrorMessage>();
        }
        if (msg.isInternalError()) {
            this.m_hasInternalError = true;
        }
        this.m_ErrorMessages.add(msg);
    }

    public CppCompilationUnit getModel() {
        return this.m_model;
    }

    public boolean requestFailed() {
        return this.m_Status < 0 || this.m_Status == 4;
    }

    public int getStatus() {
        return this.m_Status;
    }

    private boolean isRelevant(String msg) {
        return !msg.equals("Compilation terminated.") && msg.length() > 0 && !Character.isDigit(msg.charAt(0)) && !Character.isWhitespace(msg.charAt(0));
    }

    public List<ErrorMessage> getMessages() {
        if (this.m_ErrorMessages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_ErrorMessages);
    }

    public boolean hadInternalEDGError() {
        return this.m_hasInternalError;
    }

    public boolean hadInternalError() {
        return this.m_Status == -1;
    }

    public CPlusPlusModule getModule() {
        return this.m_module;
    }

    public CppSourceFile getSourceFile() {
        return this.m_sourceFile;
    }

    public void reportFailureMessage(OperationResult result) {
        result.addWarning((OperationResult.IMessageCause)CppCauses.PARSING_REQUEST_FAILED, (String)(switch (this.m_Status) {
            case -6 -> "Parser daemon terminated unexpectedly";
            case -5 -> "Parser daemon failed to start";
            case -4 -> "Parser model file was corrupted";
            case -3 -> "Parser daemon crashed";
            case -2 -> "Parser daemon exited with exception " + this.m_exceptionMessage;
            case -1 -> "Internal parser error";
            case 4 -> "File could not be parsed";
            default -> "Unknown cause: " + this.m_Status;
        }) + ". File: " + this.m_sourceFile.getName(), new Object[0]);
    }
}

