/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.DeltaDetector;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CppSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class CPlusPlusDeltaDetector
extends DeltaDetector {
    private final Set<CppSource> m_sourceFilesToParse = new LinkedHashSet<CppSource>();
    private final Set<CppSource> m_modifiedIncludeFiles = new LinkedHashSet<CppSource>();
    private CPlusPlusModule m_currentModule;
    private CppSourceFileExtensions m_fileExtensions;
    private final Set<FilePath> m_visitedFiles = new LinkedHashSet<FilePath>();
    protected final boolean m_firstModificationOnly;

    CPlusPlusDeltaDetector(IWorkerContext workerContext, ILanguageProvider languageProvider, IWorkspaceFilter filter, Module module, List<String> ignoreDirectories, boolean firstModificationOnly) {
        super(workerContext, languageProvider, filter, module, ignoreDirectories);
        this.m_firstModificationOnly = firstModificationOnly;
    }

    public void synchronize(OperationResult result) {
    }

    private void markAffectedFilesAsModified(ModuleDelta delta, FilePath sourceFile) {
        CPlusPlusModule sourceModule;
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'markAffectedFilesAsModified' must not be null";
        if (!this.m_visitedFiles.add(sourceFile)) {
            return;
        }
        CppSource source = (CppSource)sourceFile;
        LinkedHashSet<CppSource> sourcesDependingOnMe = new LinkedHashSet<CppSource>(source.getSourcesDependingOnMe());
        source.getChildrenRecursively(ProgrammingElement.class, new Class[0]).forEach(pe -> pe.getIncomingDependencies(new IStandardEnumeration[0]).forEach(dep -> {
            CppSource src = (CppSource)((Object)((Object)((Object)dep.getFrom().getParent(CppSource.class, new Class[0]))));
            if (src != source) {
                sourcesDependingOnMe.add(src);
            }
        }));
        boolean isModified = delta.isModified((FilePath)source);
        boolean isDeleted = delta.isDeleted((FilePath)source);
        if (!isDeleted) {
            source.setTimestamp(1L);
        }
        if (source.isIncludeFile()) {
            if (isModified) {
                this.m_modifiedIncludeFiles.add(source);
            }
            for (CppSource includingFile : sourcesDependingOnMe) {
                if (delta.isModified((FilePath)includingFile) || delta.isDeleted((FilePath)includingFile)) continue;
                this.markAffectedFilesAsModified(delta, (FilePath)includingFile);
            }
        } else if (!isModified && !isDeleted && (sourceModule = (CPlusPlusModule)((Object)source.getParent(CPlusPlusModule.class, new Class[0]))) != null && sourceModule == this.m_currentModule) {
            this.m_sourceFilesToParse.add(source);
        }
    }

    protected void visitModifications() {
        if (this.scanningIsDone()) {
            return;
        }
        Visitor visitor = new Visitor();
        this.m_delta.visitModified((ModuleDelta.IVisitor)visitor);
        this.m_delta.visitDeleted((ModuleDelta.IVisitor)visitor);
        this.m_visitedFiles.clear();
        for (CppSource source : this.m_sourceFilesToParse) {
            this.m_delta.modified((FilePath)source);
        }
        for (CppSource affectedIncludeFile : this.m_modifiedIncludeFiles) {
            this.m_delta.removeFromModified((FilePath)affectedIncludeFile);
        }
    }

    protected void scanRootDirectory(RootDirectoryPath root) {
        if (!this.scanningIsDone()) {
            super.scanRootDirectory(root);
        }
    }

    protected void scanDirectories(OperationResult result) {
        super.scanDirectories(result);
        if (this.m_delta != null && !this.m_firstModificationOnly) {
            this.visitModifications();
        }
    }

    protected void aboutToScanRoot(RootDirectoryPath root) {
        CPlusPlusModule module = (CPlusPlusModule)((Object)root.getParent(CPlusPlusModule.class, new Class[0]));
        if (module != this.m_currentModule) {
            this.setCurrentModule(module);
        }
    }

    protected void setCurrentModule(CPlusPlusModule module) {
        this.m_currentModule = module;
        if (this.m_currentModule != null) {
            ModuleSettings settings = (ModuleSettings)this.m_currentModule.getUniqueChild(ModuleSettings.class);
            assert (settings != null) : "Child 'settings' in method 'accepts' must not be null";
            this.m_fileExtensions = (CppSourceFileExtensions)((Object)settings.getUniqueChild(CppSourceFileExtensions.class));
            if (this.m_fileExtensions == null) {
                this.m_fileExtensions = (CppSourceFileExtensions)((Object)((CPlusPlusSystemSettings)((Object)this.m_currentModule.getParent().getUniqueExistingChild(CPlusPlusSystemSettings.class))).getUniqueChild(CppSourceFileExtensions.class));
                if (this.m_fileExtensions == null) {
                    this.m_fileExtensions = new CppSourceFileExtensions(null);
                }
            }
        } else {
            this.m_fileExtensions = null;
        }
    }

    protected boolean scanningIsDone() {
        return this.m_delta == null || this.m_firstModificationOnly && !this.m_delta.isEmpty();
    }

    public IFileType accepts(TFile file) {
        assert (file != null) : "'file' must not be null";
        String extension = FileUtility.getExtension((TFile)file);
        assert (this.m_fileExtensions != null) : "Child 'fileExtensions' in method 'accepts' must not be null";
        assert (!this.m_fileExtensions.getSourceFileExtensions().isEmpty()) : "source file extensions must not be empty.";
        CSourceFileExtensions cFileExtensions = new CSourceFileExtensions(null);
        if (this.m_fileExtensions.getSourceFileExtensions().contains(extension)) {
            return CPlusPlusFileType.CPP_SOURCE;
        }
        if (cFileExtensions.getSourceFileExtensions().contains(extension)) {
            return CPlusPlusFileType.C_SOURCE;
        }
        return null;
    }

    final class Visitor
    implements ModuleDelta.IVisitor {
        Visitor() {
        }

        public void deleted(ModuleDelta delta, FilePath filePath) {
            CPlusPlusDeltaDetector.this.markAffectedFilesAsModified(delta, filePath);
        }

        public void modified(ModuleDelta delta, FilePath filePath) {
            CPlusPlusDeltaDetector.this.markAffectedFilesAsModified(delta, filePath);
        }

        public void added(RootDirectoryPath root, IFileType fileType, TFile file) {
        }
    }
}

