/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CommandLineHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.DirectoryBeanHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SourceBeanFactory {
    private final Map<List<String>, List<String>> m_optionMap = new HashMap<List<String>, List<String>>();
    private final Set<TFile> m_sources = new LinkedHashSet<TFile>();
    private final Map<TFile, List<String>> m_fileToOptions = new HashMap<TFile, List<String>>();

    SourceBeanFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean processCommand(TFile baseDir, List<String> words) {
        TFile sourceFile;
        char secondChar;
        TFile cwd = null;
        if (words.get(0).startsWith("capture_cwd=")) {
            String cwdPath = words.get(0).substring("capture_cwd=".length());
            cwd = new TFile(cwdPath);
            words.remove(0);
        }
        words.remove(0);
        List<String> options = CommandLineHelper.filterAndNormalizeItems(baseDir, words, true);
        if (options == null) {
            return false;
        }
        assert (options.size() >= 1);
        int lastIndex = options.size() - 1;
        String sourceFileName = options.get(lastIndex);
        options.remove(lastIndex);
        int i = 0;
        while (i < options.size()) {
            String word = options.get(i);
            if (word.startsWith("-I") || word.startsWith("-F")) {
                char secondChar2;
                String prefix = word.substring(0, 2);
                String dir = word.substring(2);
                assert (dir.length() > 0);
                char firstChar = dir.charAt(0);
                char c = secondChar2 = dir.length() > 1 ? dir.charAt(1) : (char)'\u0000';
                if (firstChar != '/' && firstChar != '\\' && secondChar2 != ':') {
                    if (cwd == null) return false;
                    TFile incDir = new TFile((File)cwd, dir);
                    options.set(i, prefix + incDir.getNormalizedFile().getPath());
                }
            }
            ++i;
        }
        if (sourceFileName == null) return false;
        char firstChar = sourceFileName.charAt(0);
        char c = secondChar = sourceFileName.length() > 1 ? sourceFileName.charAt(1) : (char)'\u0000';
        if (firstChar != '/' && firstChar != '\\' && secondChar != ':') {
            if (cwd == null) return false;
            sourceFile = new TFile((File)cwd, sourceFileName);
        } else {
            sourceFile = new TFile(sourceFileName);
        }
        sourceFile = sourceFile.getNormalizedFile();
        if (!this.m_sources.add(sourceFile)) return false;
        List<String> mappedOptions = this.m_optionMap.get(options);
        if (mappedOptions == null) {
            this.m_optionMap.put(options, options);
            mappedOptions = options;
        }
        this.m_sources.add(sourceFile);
        this.m_fileToOptions.put(sourceFile, mappedOptions);
        return true;
    }

    boolean isEmpty() {
        return this.m_sources.isEmpty();
    }

    List<DirectoryBean> getRootDirectories() {
        return DirectoryBeanHelper.createRoots(this.m_sources, this.m_fileToOptions);
    }
}

