/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemSettingsExtension;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.SoftwareSystemSettingsFile;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CCSpyDirectory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.Comment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ForcedIncludeOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GenericCompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.Macro;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleOrSystemCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SettingsBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SettingsDelta;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SysInclude;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusCMakeJsonModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusCaptureModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusManualModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICPlusPlusSoftwareSystemSettingsProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.settings.CPlusPlusDefaultUnboundExternalFilter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.settings.CPlusPlusUnboundExternalFilter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.settings.CPlusPlusUserDefinedUnboundExternalFilter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.settings.CPlusPlusSoftwareSystemSettingsPersistence;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CPlusPlusSoftwareSystemSettingsExtension
extends SoftwareSystemSettingsExtension
implements ICPlusPlusSoftwareSystemSettingsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusSoftwareSystemSettingsExtension.class);
    private final ICPlusPlusInstallationExtension m_instProvider;
    private final IFinishModelProcessor m_finishModelProcessor;
    private final IListener m_listener;
    private final Map<String, List<String>> m_sourceFileOptions = new THashMap();

    public CPlusPlusSoftwareSystemSettingsExtension(Installation installation, SoftwareSystem system, ICPlusPlusInstallationExtension installationSettingsProvider, IFinishModelProcessor finishModelProcessor, IListener listener) {
        super(installation, system);
        assert (installationSettingsProvider != null) : "Parameter 'installationSettingsProvider' of method 'CPlusPlusSoftwareSystemSettingsExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'CPlusPlusSoftwareSystemSettingsExtension' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'CPlusPlusSoftwareSystemSettingsExtension' must not be null";
        this.m_instProvider = installationSettingsProvider;
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_listener = listener;
    }

    @Override
    public List<String> getCppCompilerOptionsForSource(ModuleCompilerOptions moduleOptions, SourceFile sourceFile) {
        assert (moduleOptions != null) : "Parameter 'moduleOptions' of method 'getCppCompilerOptionsForSource' must not be null";
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getCppCompilerOptionsForSource' must not be null";
        InstCompilerDefinition activeDefinition = this.m_instProvider.getActiveCompilerDefinition();
        ArrayList<String> options = new ArrayList<String>();
        options.addAll(this.translateOptions(activeDefinition, moduleOptions));
        CompilerOptions sourceFileOptions = ((CPlusPlusModule)((Object)moduleOptions.getParent(CPlusPlusModule.class, new Class[0]))).getSourceFileOptions(sourceFile);
        options.addAll(this.translateOptions(activeDefinition, sourceFileOptions));
        options.addAll(activeDefinition.listCppOptions());
        options.addAll(this.getOptionsForFile(sourceFile));
        return options;
    }

    @Override
    public List<String> getCCompilerOptionsForSource(ModuleCompilerOptions moduleOptions, SourceFile sourceFile) {
        assert (moduleOptions != null) : "Parameter 'moduleOptions' of method 'getCppCompilerOptionsForSource' must not be null";
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getCppCompilerOptionsForSource' must not be null";
        InstCompilerDefinition activeDefinition = this.m_instProvider.getActiveCompilerDefinition();
        ArrayList<String> options = new ArrayList<String>();
        options.addAll(this.translateOptions(activeDefinition, moduleOptions));
        CompilerOptions sourceFileOptions = ((CPlusPlusModule)((Object)moduleOptions.getParent(CPlusPlusModule.class, new Class[0]))).getSourceFileOptions(sourceFile);
        options.addAll(this.translateOptions(activeDefinition, sourceFileOptions));
        options.addAll(activeDefinition.listCOptions());
        options.addAll(this.getOptionsForFile(sourceFile));
        return options;
    }

    private List<String> getOptionsForFile(SourceFile src) {
        List<String> result = this.m_sourceFileOptions.get(src.getFile().getNormalizedAbsolutePath());
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public void registerOptions(String fileName, List<String> options) {
        assert (fileName != null);
        assert (options != null);
        this.m_sourceFileOptions.put(fileName, options);
    }

    private List<String> translateOptions(InstCompilerDefinition activeDefinition, CompilerOptions compilerOptions) {
        assert (activeDefinition != null) : "Parameter 'activeDefinition' of method 'translateOptions' must not be null";
        if (compilerOptions == null) {
            return Collections.emptyList();
        }
        ArrayList<String> options = new ArrayList<String>();
        for (ICompilerOption option : compilerOptions.getChildren(ICompilerOption.class)) {
            String translatedOption;
            String value = option.getValue();
            if (option instanceof IncludeOption || option instanceof SysInclude || option instanceof ForcedIncludeOption) {
                options.add(value);
                continue;
            }
            if (option instanceof Macro) {
                translatedOption = activeDefinition.translateOption(value, value);
                if ("".equals(translatedOption)) continue;
                options.add(translatedOption);
                continue;
            }
            if (option instanceof Comment || !(option instanceof GenericCompilerOption) || "".equals(translatedOption = activeDefinition.translateOption(value, ""))) continue;
            options.add(translatedOption);
        }
        return options;
    }

    @Override
    public ModuleCompilerOptions getActiveCompilerOptions(CPlusPlusModule module) {
        assert (module != null) : "Parameter 'module' of method 'getActiveCompilerOptions' must not be null";
        InstCompilerDefinition activeDefinition = this.m_instProvider.getActiveCompilerDefinition();
        ModuleCompilerOptions activeModuleOptions = this.getActiveModuleOptions(activeDefinition, module);
        return activeModuleOptions;
    }

    private ModuleCompilerOptions getActiveModuleOptions(InstCompilerDefinition activeDefinition, CPlusPlusModule cppModule) {
        assert (activeDefinition != null) : "Parameter 'activeDefinition' of method 'getActiveModuleOptions' must not be null";
        assert (cppModule != null) : "Parameter 'cppModule' of method 'getActiveModuleOptions' must not be null";
        CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)cppModule.getParent().getUniqueExistingChild(CPlusPlusSystemSettings.class));
        ModuleSettings moduleSettings = (ModuleSettings)cppModule.getUniqueChild(ModuleSettings.class);
        ModuleCompilerOptions moduleOptions = new ModuleCompilerOptions((NamedElement)moduleSettings, activeDefinition.getName());
        this.addOptionsToResult(moduleOptions, (NamedElementContainer)systemSettings, "Any Compiler");
        this.addOptionsToResult(moduleOptions, (NamedElementContainer)systemSettings, activeDefinition.getName());
        this.addOptionsToResult(moduleOptions, (NamedElementContainer)moduleSettings, "Any Compiler");
        this.addOptionsToResult(moduleOptions, (NamedElementContainer)moduleSettings, activeDefinition.getName());
        return moduleOptions;
    }

    private void addOptionsToResult(ModuleCompilerOptions result, NamedElementContainer settings, String compilerName) {
        assert (result != null) : "Parameter 'moduleOptions' of method 'addOptionsToResult' must not be null";
        assert (settings != null) : "Parameter 'settings' of method 'addOptionsToResult' must not be null";
        assert (compilerName != null && compilerName.length() > 0) : "Parameter 'compilerName' of method 'addOptionsToResult' must not be empty";
        ModuleOrSystemCompilerOptions compilerOptions = (ModuleOrSystemCompilerOptions)((Object)settings.getUniqueChild((NamedElement.IFilter)new NameFilter(compilerName), ModuleOrSystemCompilerOptions.class));
        if (compilerOptions != null) {
            result.addOptions(compilerOptions.getOptions());
        }
    }

    @Override
    public Set<TFile> getSystemIncludes(ModuleCompilerOptions options) {
        LinkedHashSet<TFile> sysIncludeDirs = new LinkedHashSet<TFile>();
        for (SysInclude sysInclude : this.m_instProvider.getActiveCompilerDefinition().getChildrenRecursively(SysInclude.class, new Class[0])) {
            sysIncludeDirs.add(sysInclude.getFile());
        }
        for (SysInclude sysInclude : options.getChildrenRecursively(SysInclude.class, new Class[0])) {
            sysIncludeDirs.add(sysInclude.getFile());
        }
        return sysIncludeDirs;
    }

    @Override
    public void handleChangeOfActiveCompilerDefinition(String activeDefinitionName) {
        assert (activeDefinitionName != null && activeDefinitionName.length() > 0) : "Parameter 'activeDefinitionName' of method 'handleChangeOfActiveCompilerDefinition' must not be empty";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Notify about changed C++ compiler definition.");
        }
        if (this.getSoftwareSystem().getMode() == SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT) {
            return;
        }
        for (CPlusPlusModule module : ((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusModule.class)) {
            ModuleCompilerOptions options;
            if (module instanceof CPlusPlusManualModule || module instanceof CPlusPlusCMakeJsonModule || module instanceof CPlusPlusCaptureModule || module.isAutomatic() || (options = (ModuleCompilerOptions)((Object)((ModuleSettings)module.getUniqueChild(ModuleSettings.class)).getUniqueChild(ModuleCompilerOptions.class))) == null || options.getName().equals(activeDefinitionName)) continue;
            options.setName(activeDefinitionName);
        }
        this.getSoftwareSystem().setNeedsReparse(true);
        CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueChild(CPlusPlusSystemSettings.class));
        systemSettings.removeIssues();
        this.m_finishModelProcessor.finishModification((IWorkerContext)DefaultWorkerContext.INSTANCE, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), new OperationResult("Change of active compiler definition"));
    }

    @Override
    public OperationResultWithOutcome<Map<String, NamedElement>> getAllManualModuleConfigurations() {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load module configurations for all C++ modules");
        LinkedHashMap<String, CPlusPlusSystemSettings> settingsMap = new LinkedHashMap<String, CPlusPlusSystemSettings>();
        result.setOutcome(settingsMap);
        OperationResultWithOutcome loadDefinitionsResult = this.m_instProvider.loadRelevantDefinitions();
        result.addMessagesFrom((OperationResult)loadDefinitionsResult);
        if (result.isFailure()) {
            return result;
        }
        Map definitions = (Map)loadDefinitionsResult.getOutcome();
        Set<String> compilerDefinitionNames = definitions.keySet();
        Workspace ws = (Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class);
        List modules = ws.getChildren(CPlusPlusManualModule.class);
        if (!modules.isEmpty()) {
            CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)ws.getUniqueExistingChild(CPlusPlusSystemSettings.class));
            SettingsBuilder.addOptionsForMissingDefinitions((NamedElement)systemSettings, compilerDefinitionNames);
            settingsMap.put("System settings", systemSettings);
            for (CPlusPlusManualModule module : modules) {
                ModuleSettings settings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
                SettingsBuilder.addOptionsForMissingDefinitions((NamedElement)settings, compilerDefinitionNames);
                settingsMap.put(module.getShortName(), (CPlusPlusSystemSettings)settings);
            }
        }
        return result;
    }

    @Override
    public OperationResult applyManualModuleSettings(IWorkerContext workerContext, Map<String, SettingsDelta> deltaMap) {
        assert (deltaMap != null) : "Parameter 'delta' of method 'applyModuleSettings' must not be null";
        OperationResult result = new OperationResult("Apply Manual Module Settings");
        boolean modified = false;
        for (Map.Entry<String, SettingsDelta> entry : deltaMap.entrySet()) {
            SettingsDelta delta = entry.getValue();
            if (!delta.isModified()) {
                LOGGER.debug("Module settings for module '" + entry.getKey() + "' have not been modified");
                delta.dispose();
                continue;
            }
            NamedElement original = delta.getOriginal();
            CCSpyDirectory ccspyDir = (CCSpyDirectory)((Object)original.getFirstChild(CCSpyDirectory.class));
            if (ccspyDir != null) {
                ccspyDir.changeParent(delta.getModified(), true);
            }
            NamedElement parent = original.getParent();
            parent.removeChild(original);
            delta.getOriginal().setParent(null);
            parent.addChild(delta.getModified());
            modified = true;
        }
        if (modified) {
            this.getSoftwareSystem().removeIssuesOfInvalidElements();
            WorkspaceExtension.setNeedsReparse((SoftwareSystem)this.getSoftwareSystem(), (OperationResult)result);
            this.getSoftwareSystem().setNeedsSave(true);
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), result);
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<TFile> initPreprocessorOutputDirectory() {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Creating C++ preprocessing directory");
        TFile hiddenDataDirectory = ((Files)this.getSoftwareSystem().getUniqueExistingChild(Files.class)).getHiddenDataDirectory();
        TFile preprocessingOutput = new TFile((File)hiddenDataDirectory, ".preprocessing");
        TrueZipFacade.clear((TFile)preprocessingOutput);
        if (preprocessingOutput.exists() && preprocessingOutput.isDirectory()) {
            try {
                FileUtility.deleteRecursively((String)preprocessingOutput.getAbsolutePath());
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)e);
            }
        }
        try {
            preprocessingOutput.mkdir(true);
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, (Throwable)e);
            return result;
        }
        result.setOutcome((Object)preprocessingOutput);
        return result;
    }

    public static void aboutToCreateFirstModule(Workspace workspace) {
        assert (workspace != null) : "Parameter 'workspace' of method 'aboutToCreateFirstModule' must not be null";
        LOGGER.debug("Create default C,C++ unbound external filter");
        CPlusPlusDefaultUnboundExternalFilter filter = (CPlusPlusDefaultUnboundExternalFilter)((Object)workspace.getUniqueChild(CPlusPlusDefaultUnboundExternalFilter.class));
        assert (filter == null) : "'filter' of method 'aboutToCreateFirstModule' must be null";
        filter = new CPlusPlusDefaultUnboundExternalFilter((NamedElement)workspace);
        workspace.addChild((NamedElement)filter);
    }

    public static void lastModuleDeleted(Workspace workspace) {
        assert (workspace != null) : "Parameter 'workspace' of method 'lastModuleDeleted' must not be null";
        LOGGER.debug("Remove default C,C++ unbound external filter");
        ((CPlusPlusDefaultUnboundExternalFilter)((Object)workspace.getUniqueExistingChild(CPlusPlusDefaultUnboundExternalFilter.class))).remove();
    }

    public static boolean doSoftwareSystemSettingsMatch(Workspace sourceWorkspace, Workspace targetWorkspace, OperationResult result) {
        assert (sourceWorkspace != null) : "Parameter 'sourceWorkspace' of method 'doSoftwareSystemSettingsMatch' must not be null";
        assert (targetWorkspace != null) : "Parameter 'targetWorkspace' of method 'doSoftwareSystemSettingsMatch' must not be null";
        assert (result != null) : "Parameter 'result' of method 'doSoftwareSystemSettingsMatch' must not be null";
        CPlusPlusDefaultUnboundExternalFilter sourceDefaultFilter = (CPlusPlusDefaultUnboundExternalFilter)((Object)sourceWorkspace.getUniqueChild(CPlusPlusDefaultUnboundExternalFilter.class));
        if (sourceDefaultFilter != null) {
            CPlusPlusDefaultUnboundExternalFilter targetDefaultFilter = (CPlusPlusDefaultUnboundExternalFilter)((Object)targetWorkspace.getUniqueExistingChild(CPlusPlusDefaultUnboundExternalFilter.class));
            if (!targetDefaultFilter.getCurrentlyUsedSignature().equals(sourceDefaultFilter.getCurrentlyUsedSignature())) {
                LOGGER.debug("C,C++ unbound external filter does not match");
                return false;
            }
        } else {
            sourceWorkspace.addChild((NamedElement)new CPlusPlusDefaultUnboundExternalFilter((NamedElement)sourceWorkspace));
        }
        LOGGER.debug("C,C++ unbound external filter matches");
        return true;
    }

    private CPlusPlusSoftwareSystemSettingsPersistence getPersistence() {
        return new CPlusPlusSoftwareSystemSettingsPersistence(this.getInstallation().getVersion());
    }

    protected Language getLanguage() {
        return CPlusPlusLanguage.INSTANCE;
    }

    protected OperationResult loadSettingsFileContentInto(TFile file, NamedElement into, EnumSet<Modification> modifications) {
        assert (file != null) : "Parameter 'file' of method 'performLoad' must not be null";
        assert (into != null) : "Parameter 'into' of method 'performLoad' must not be null";
        assert (!into.hasChildren()) : "Not empty: " + String.valueOf(into.getChildren());
        LOGGER.debug("Load C,C++ unnbound external filter file: " + file.getAbsolutePath());
        OperationResult result = this.getPersistence().load(file, into);
        if (result.isSuccess()) {
            LOGGER.debug("Success");
            if (((CPlusPlusDefaultUnboundExternalFilter)((Object)((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(CPlusPlusDefaultUnboundExternalFilter.class))).setCurrentlyUsedSignature(((CPlusPlusUserDefinedUnboundExternalFilter)((Object)into.getUniqueExistingChild(CPlusPlusUserDefinedUnboundExternalFilter.class))).createStringRepresentation())) {
                LOGGER.debug("Current filter changed");
                this.m_listener.unboundExternalFilterModified();
            } else {
                LOGGER.debug("Current filter not changed");
            }
            return result;
        }
        LOGGER.debug("Failure: " + String.valueOf(result));
        return result;
    }

    protected OperationResult saveSettingsFile(SoftwareSystemSettingsFile settingsFile, TFile targetFile) {
        assert (settingsFile != null) : "Parameter 'settingsFile' of method 'performSave' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'saveSettingsFile' must not be null";
        LOGGER.debug("Save Java ignore access to file: " + targetFile.getAbsolutePath());
        OperationResult result = this.getPersistence().save((NamedElement)settingsFile, targetFile);
        if (result.isSuccess()) {
            LOGGER.debug("Success");
            return result;
        }
        LOGGER.debug("Failure: " + String.valueOf(result));
        return result;
    }

    protected void restoreDefaults(EnumSet<Modification> modifications) {
        LOGGER.debug("Restore defaults");
        CPlusPlusDefaultUnboundExternalFilter defaultFilter = (CPlusPlusDefaultUnboundExternalFilter)((Object)((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(CPlusPlusDefaultUnboundExternalFilter.class));
        if (defaultFilter.setCurrentlyUsedSignature(defaultFilter.getOwnSignature())) {
            LOGGER.debug("Defaults differ");
            this.m_listener.unboundExternalFilterModified();
        } else {
            LOGGER.debug("Defaults do not differ");
        }
    }

    @Override
    public CPlusPlusUnboundExternalFilter getUnboundExternalFilterForEdit() {
        CPlusPlusUnboundExternalFilter filter = (CPlusPlusUnboundExternalFilter)((Object)this.getSoftwareSystemSettingsFile().getUniqueChild(CPlusPlusUserDefinedUnboundExternalFilter.class));
        return filter == null ? (CPlusPlusUnboundExternalFilter)((Object)((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(CPlusPlusDefaultUnboundExternalFilter.class)) : filter;
    }

    public CPlusPlusUnboundExternalFilter getUnboundExternalFilter() {
        CPlusPlusUnboundExternalFilter filter = (CPlusPlusUnboundExternalFilter)((Object)this.getSoftwareSystemSettingsFile().getUniqueChild(CPlusPlusUserDefinedUnboundExternalFilter.class));
        return filter == null ? (CPlusPlusUnboundExternalFilter)((Object)((Workspace)this.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(CPlusPlusDefaultUnboundExternalFilter.class)) : filter;
    }

    public static interface IListener {
        public void unboundExternalFilterModified();
    }
}

