/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.windows.VisualStudioInstallationsDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.IVisualStudioInstallationsExtension;
import java.util.Collections;
import java.util.List;

public class UpdateVisualStudioInstallationsCommand
extends SonargraphCommand {
    private final IInteraction m_interaction;

    public UpdateVisualStudioInstallationsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'UpdateVisualStudioInstallationsCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return CPlusPlusCommandId.UPDATE_VISUAL_STUDIO_INSTALLATIONS;
    }

    protected boolean isUndoable() {
        return false;
    }

    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CommandData data = new CommandData();
        if (this.m_interaction.fillData(data)) {
            IVisualStudioInstallationsExtension extension = (IVisualStudioInstallationsExtension)this.getController().getInstallation().getExtension(IVisualStudioInstallationsExtension.class);
            OperationResult result = extension.updateLocations(workerContext, data.getAddedLocations(), data.getRemovedLocations());
            this.m_interaction.processOperationResult(result);
        }
    }

    public class CommandData {
        private List<VisualStudioInstallationsDetector.Location> m_addedLocations;
        private List<VisualStudioInstallationsDetector.Location> m_removedLocations;

        public List<VisualStudioInstallationsDetector.Location> getAddedLocations() {
            return this.m_addedLocations == null ? Collections.emptyList() : this.m_addedLocations;
        }

        public void setAddedLocations(List<VisualStudioInstallationsDetector.Location> addedLocations) {
            this.m_addedLocations = addedLocations;
        }

        public List<VisualStudioInstallationsDetector.Location> getRemovedLocations() {
            return this.m_removedLocations == null ? Collections.emptyList() : this.m_removedLocations;
        }

        public void setRemovedLocations(List<VisualStudioInstallationsDetector.Location> removedLocations) {
            this.m_removedLocations = removedLocations;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean fillData(CommandData var1);

        public void processOperationResult(OperationResult var1);
    }
}

