/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.detector;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProjectUnit {
    private final List<File> m_sourceFolders = new ArrayList<File>();
    private final List<File> m_classFolders = new ArrayList<File>();
    private final File m_root;
    private final String m_name;

    public ProjectUnit(File root, String name) {
        assert (root != null) : "Parameter 'root' of method 'ProjectUnit' must not be null";
        assert (root.isDirectory());
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ProjectUnit' must not be empty";
        this.m_root = root;
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void addSourceFolder(File folder) {
        assert (folder != null) : "Parameter 'folder' of method 'addSourceFolder' must not be null";
        assert (folder.isDirectory() || folder.isFile());
        this.m_sourceFolders.add(folder);
    }

    public void addClassFolder(File folder) {
        assert (folder != null) : "Parameter 'folder' of method 'addClassFolder' must not be null";
        assert (folder.isDirectory() || folder.isFile());
        this.m_classFolders.add(folder);
    }

    public List<File> getSourceFolders() {
        return Collections.unmodifiableList(this.m_sourceFolders);
    }

    public List<File> getClassFolders() {
        return Collections.unmodifiableList(this.m_classFolders);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int cutOffLength = this.m_root.getParentFile().getPath().length() + 1;
        sb.append("  Unit ").append(this.getName()).append(":\n");
        for (File dir : this.m_sourceFolders) {
            sb.append("    src: ").append(dir.getPath().substring(cutOffLength)).append('\n');
        }
        for (File dir : this.m_classFolders) {
            sb.append("    cls: ").append(dir.getPath().substring(cutOffLength)).append('\n');
        }
        return sb.toString();
    }
}

