/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaModuleModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.JavaFileProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.AspectJFileCorrespondingClassFileMissing;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.AspectJFileDuplicate;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public final class AspectJFileProcessor
extends JavaFileProcessor {
    public AspectJFileProcessor(IJavaGlobalModel javaProgrammingModel, IJavaModuleModel moduleModel, IFilePathListener listener) {
        super(javaProgrammingModel, moduleModel, listener);
    }

    public void process(JavaSourceRootDirectoryPath sourceRootDirectory, TFile file) {
        assert (sourceRootDirectory != null) : "Parameter 'sourceRootDirectory' of method 'process' must not be null";
        assert (file != null) : "Parameter 'file' of method 'process' must not be null";
        assert (JavaFileType.determine(file.getName()) == JavaFileType.ASPECTJ_FILE) : "Parameter 'file' of method 'process' must be an AspectJ file: " + String.valueOf(file);
        String relPath = FileUtility.calculateRelativePath((TFile)file, (TFile)sourceRootDirectory.getFile());
        JavaInternalCompilationUnit javaInternalCompilationUnit = this.getModuleModel().getInternalCompilationUnit(relPath);
        if (javaInternalCompilationUnit != null) {
            JavaSourceFile javaSourceFile = this.createSourceFile(JavaFileType.JAVA_FILE, sourceRootDirectory, file);
            javaSourceFile.addIssue((Issue)new AspectJFileDuplicate((NamedElement)javaSourceFile, "AspectJ file already added for relative path '" + relPath + "' from '" + javaInternalCompilationUnit.getAbsolutePath() + "'"));
        } else {
            List<JavaType> javaTypes = this.getModuleModel().getAspectJTypes(relPath);
            if (!javaTypes.isEmpty()) {
                this.createSourceFile(JavaFileType.ASPECTJ_FILE, sourceRootDirectory, file, javaTypes);
            } else {
                JavaSourceFile javaSourceFile = this.createSourceFile(JavaFileType.ASPECTJ_FILE, sourceRootDirectory, file);
                javaSourceFile.addIssue((Issue)new AspectJFileCorrespondingClassFileMissing((NamedElement)javaSourceFile));
            }
        }
    }
}

