/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system;

import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.persistence.system.PersistenceCause;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SoftwareSystemComponentFilterReader {
    private SoftwareSystemComponentFilterReader() {
    }

    public static OperationResultWithOutcome<ComponentFilterPatterns> read(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'read' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Read component filter patterns");
        ComponentFilterPatterns properties = new ComponentFilterPatterns();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (TFileInputStream is = new TFileInputStream((File)file);){
                SAXParserFactory.newInstance().newSAXParser().parse((InputStream)is, (DefaultHandler)new Handler(properties, (OperationResult)result));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, ExceptionUtility.collectAll((Throwable)ioe), new Object[0]);
        }
        catch (Exception ex) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.UNABLE_TO_PARSE, ExceptionUtility.collectAll((Throwable)ex), new Object[0]);
        }
        if (result.isSuccess()) {
            result.setOutcome((Object)properties);
        }
        return result;
    }

    public static final class ComponentFilterPatterns {
        private final Set<String> m_productionnCodeFilterIncludes = new LinkedHashSet<String>();
        private final Set<String> m_productionCodeFilterExcludes = new LinkedHashSet<String>();
        private final Set<String> m_issueFilterIncludes = new LinkedHashSet<String>();
        private final Set<String> m_issueFilterExcludes = new LinkedHashSet<String>();

        private ComponentFilterPatterns() {
        }

        public void addPattern(Node node, String pattern) {
            assert (node != null) : "Parameter 'node' of method 'addPattern' must not be null";
            assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'addPattern' must not be empty";
            switch (node) {
                case PRODUCTION_CODE_FILTER_INCLUDE: {
                    this.m_productionnCodeFilterIncludes.add(pattern);
                    break;
                }
                case PRODUCTION_CODE_FILTER_EXCLUDE: {
                    this.m_productionCodeFilterExcludes.add(pattern);
                    break;
                }
                case ISSUE_FILTER_INCLUDE: {
                    this.m_issueFilterIncludes.add(pattern);
                    break;
                }
                case ISSUE_FILTER_EXCLUDE: {
                    this.m_issueFilterExcludes.add(pattern);
                    break;
                }
                default: {
                    assert (false) : "Unhandled node: " + String.valueOf((Object)node);
                    break;
                }
            }
        }

        public Set<String> getProductionCodeFilterIncludes() {
            return Collections.unmodifiableSet(this.m_productionnCodeFilterIncludes);
        }

        public Set<String> getProductionCodeFilterExcludes() {
            return Collections.unmodifiableSet(this.m_productionCodeFilterExcludes);
        }

        public Set<String> getIssueFilterIncludes() {
            return Collections.unmodifiableSet(this.m_issueFilterIncludes);
        }

        public Set<String> getIssueFilterExcludes() {
            return Collections.unmodifiableSet(this.m_issueFilterExcludes);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (String next : this.m_productionnCodeFilterIncludes) {
                builder.append("Production code filter include: ").append(next).append("\n");
            }
            for (String next : this.m_productionCodeFilterExcludes) {
                builder.append("Production code filter exclude: ").append(next).append("\n");
            }
            for (String next : this.m_issueFilterIncludes) {
                builder.append("Issue filter include: ").append(next).append("\n");
            }
            for (String next : this.m_issueFilterExcludes) {
                builder.append("Issue filter exclude: ").append(next).append("\n");
            }
            return builder.toString();
        }

        public boolean hasPatterns() {
            return !this.m_productionnCodeFilterIncludes.isEmpty() || !this.m_productionCodeFilterExcludes.isEmpty() || !this.m_issueFilterIncludes.isEmpty() || !this.m_issueFilterExcludes.isEmpty();
        }

        public boolean hasProductionCodeFilterPatterns() {
            return !this.m_productionnCodeFilterIncludes.isEmpty() || !this.m_productionCodeFilterExcludes.isEmpty();
        }

        public boolean hasIssueFilterPatterns() {
            return !this.m_issueFilterIncludes.isEmpty() || !this.m_issueFilterExcludes.isEmpty();
        }

        static final class Node
        extends Enum<Node>
        implements IStandardEnumeration {
            public static final /* enum */ Node PRODUCTION_CODE_FILTER_INCLUDE = new Node("include");
            public static final /* enum */ Node PRODUCTION_CODE_FILTER_EXCLUDE = new Node("exclude");
            public static final /* enum */ Node ISSUE_FILTER_INCLUDE = new Node("issueFilterInclude");
            public static final /* enum */ Node ISSUE_FILTER_EXCLUDE = new Node("issueFilterExclude");
            private final String m_qName;
            private static final /* synthetic */ Node[] ENUM$VALUES;

            static {
                ENUM$VALUES = new Node[]{PRODUCTION_CODE_FILTER_INCLUDE, PRODUCTION_CODE_FILTER_EXCLUDE, ISSUE_FILTER_INCLUDE, ISSUE_FILTER_EXCLUDE};
            }

            private Node(String qName) {
                assert (qName != null && qName.length() > 0) : "Parameter 'qName' of method 'Node' must not be empty";
                this.m_qName = qName;
            }

            public String getQName() {
                return this.m_qName;
            }

            public String getStandardName() {
                return StringUtility.convertConstantNameToStandardName((String)this.name());
            }

            public String getPresentationName() {
                return StringUtility.convertConstantNameToPresentationName((String)this.name());
            }

            public static Node[] values() {
                Node[] nodeArray = ENUM$VALUES;
                int n = nodeArray.length;
                Node[] nodeArray2 = new Node[n];
                System.arraycopy(ENUM$VALUES, 0, nodeArray2, 0, n);
                return nodeArray2;
            }

            public static Node valueOf(String string) {
                return Enum.valueOf(Node.class, string);
            }
        }
    }

    private static final class Handler
    extends DefaultHandler {
        private final ComponentFilterPatterns m_patterns;
        private final OperationResult m_result;
        private ComponentFilterPatterns.Node m_currentNode;

        Handler(ComponentFilterPatterns patterns, OperationResult result) {
            assert (patterns != null) : "Parameter 'patterns' of method 'tHandler' must not be null";
            assert (result != null) : "Parameter 'result' of method 'Handler' must not be null";
            this.m_patterns = patterns;
            this.m_result = result;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            assert (qName != null) : "Parameter 'qName' of method 'startElement' must not be null";
            assert (attributes != null) : "Parameter 'attributes' of method 'startElement' must not be null";
            if (this.m_result.isFailure()) {
                return;
            }
            if (ComponentFilterPatterns.Node.PRODUCTION_CODE_FILTER_INCLUDE.getQName().equals(qName)) {
                this.m_currentNode = ComponentFilterPatterns.Node.PRODUCTION_CODE_FILTER_INCLUDE;
            } else if (ComponentFilterPatterns.Node.PRODUCTION_CODE_FILTER_EXCLUDE.getQName().equals(qName)) {
                this.m_currentNode = ComponentFilterPatterns.Node.PRODUCTION_CODE_FILTER_EXCLUDE;
            } else if (ComponentFilterPatterns.Node.ISSUE_FILTER_INCLUDE.getQName().equals(qName)) {
                this.m_currentNode = ComponentFilterPatterns.Node.ISSUE_FILTER_INCLUDE;
            } else if (ComponentFilterPatterns.Node.ISSUE_FILTER_EXCLUDE.getQName().equals(qName)) {
                this.m_currentNode = ComponentFilterPatterns.Node.ISSUE_FILTER_EXCLUDE;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.m_currentNode = null;
        }

        private String getString(char[] ch, int start, int length) {
            String valueOf;
            if (ch != null && !(valueOf = String.valueOf(ch, start, length).replace('\n', ' ').trim()).isEmpty()) {
                return valueOf;
            }
            return null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String pattern;
            if (this.m_currentNode != null && (pattern = this.getString(ch, start, length)) != null) {
                String notValid = WildcardPattern.isValid(pattern);
                if (notValid == null) {
                    this.m_patterns.addPattern(this.m_currentNode, pattern);
                } else {
                    this.m_result.addWarning((OperationResult.IMessageCause)PersistenceCause.PATTERN_NOT_VALID, this.m_currentNode.getPresentationName() + " not valid: '" + pattern + "'", new Object[0]);
                }
            }
        }
    }
}

