/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;

public abstract class SignatureElement
extends NamedElement {
    private String m_signature;

    public SignatureElement(NamedElement parent) {
        super(parent);
    }

    public SignatureElement(NamedElement parent, String signature) {
        super(parent);
        assert (signature != null && signature.length() > 0) : "Parameter 'signature' of method 'Md5SignatureElement' must not be empty";
        this.m_signature = signature;
    }

    @Override
    public String getShortName() {
        return this.m_signature;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.getClass().getSimpleName() + INNER_NAME_PARTS_SEPARATOR + super.getFullyQualifiedNamePart();
    }

    @Override
    public final String getImageResourceName() {
        return "Configuration";
    }

    public String getSignedElementName() {
        NamedElement signedElement = this.getParent();
        assert (signedElement != null) : "'signedElement' of method 'getSignedElementName' must not be null";
        return signedElement.getName();
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_signature);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_signature = reader.readString();
    }
}

