/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.core.model.system.UnmodifiableRootModel;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.io.IOException;
import java.util.Collections;

public final class ParserModel
extends UnmodifiableRootModel {
    public static final String PARSER_MODEL_NAME = "Parser";
    private VirtualModel m_activeProductionModel;

    public ParserModel(NamedElement parent) {
        super(parent);
    }

    public void setActiveProductionModel(VirtualModel model) {
        assert (model == null || model != this) : "Model must be a different instance: " + String.valueOf(model);
        this.m_activeProductionModel = model;
    }

    public VirtualModel getActiveProductionModel() {
        return this.m_activeProductionModel;
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        for (Issue next : this.getAllIssues(true, true, true)) {
            if (!next.getAffectedElement().persist(writer.getMode()) || !next.persist(writer.getMode())) continue;
            writer.write(next);
        }
        writer.writeString(null);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        Issue issue;
        super.retrieve(reader);
        while ((issue = reader.read(Issue.class, new SnapshotArgument[0])) != null) {
            this.addElementIssue((ElementWithIssues)issue.getAffectedElement(), issue);
        }
    }

    @Override
    public String getShortName() {
        return PARSER_MODEL_NAME;
    }

    @Override
    @Property
    public String getDescription() {
        return "Represents the unmodifiable parser model";
    }

    public void initializeFrom(ParserModel from) {
        assert (from != null) : "Parameter 'from' of method 'copyFrom' must not be null";
        assert (this != from) : "Same instance";
        this.getElementWithIssues().putAll(from.getElementWithIssues());
    }

    @Override
    protected void issueRemoved(Issue issue) {
        super.issueRemoved(issue);
        if (this.m_activeProductionModel != null) {
            this.m_activeProductionModel.issueRemoved(issue);
        }
        this.issuesRemoved(Collections.singletonList(issue));
    }

    @Override
    protected void issueAdded(Issue issue) {
        super.issueAdded(issue);
        if (this.m_activeProductionModel != null) {
            this.m_activeProductionModel.issueAdded(issue);
        }
        this.issuesAdded(Collections.singletonList(issue));
    }
}

