/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class DeleteRefactoringData {
    private final List<EdgeOption> m_edgeOptions = new ArrayList<EdgeOption>(3);
    private final List<Element> m_elements;
    private final StructureMode m_structureMode;
    private final Set<ParserDependency> m_violating;
    private final String m_edgeOptionsInfo;
    private final RecursiveElementChildrenOption m_recursiveElementChildrenOption;
    private final Kind m_kind;
    private EdgeOption m_edgeOption;

    public DeleteRefactoringData(Kind kind, List<Element> elements, StructureMode structureMode) {
        assert (kind != null) : "Parameter 'kind' of method 'DeleteRefactoringData' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'DeleteRefactoringData' must not be empty";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'DeleteRefactoringData' must not be null";
        this.m_kind = kind;
        this.m_elements = new ArrayList<Element>(elements);
        this.m_structureMode = structureMode;
        this.m_edgeOptionsInfo = "";
        this.m_recursiveElementChildrenOption = null;
        this.m_violating = Collections.emptySet();
    }

    public DeleteRefactoringData(Kind kind, List<Element> elements, StructureMode structureMode, RecursiveElementChildrenOption recursiveElementChildrenOption) {
        assert (kind != null) : "Parameter 'kind' of method 'DeleteRefactoringData' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'DeleteRefactoringData' must not be empty";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'DeleteRefactoringData' must not be null";
        assert (recursiveElementChildrenOption != null) : "Parameter 'recursiveElementChildrenOption' of method 'DeleteRefactoringData' must not be null";
        this.m_kind = kind;
        this.m_elements = new ArrayList<Element>(elements);
        this.m_structureMode = structureMode;
        this.m_recursiveElementChildrenOption = recursiveElementChildrenOption;
        this.m_edgeOptionsInfo = "";
        this.m_violating = Collections.emptySet();
    }

    public DeleteRefactoringData(Kind kind, List<Element> elements, StructureMode structureMode, List<EdgeOption> options, EdgeOption setOption, String edgeOptionsInfo, Set<ParserDependency> violating, RecursiveElementChildrenOption recursiveElementChildrenOption) {
        assert (kind != null) : "Parameter 'kind' of method 'DeleteRefactoringData' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'DeleteRefactoringData' must not be empty";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'DeleteRefactoringData' must not be null";
        assert (options != null && !options.isEmpty()) : "Parameter 'options' of method 'DeleteRefactoringData' must not be empty";
        assert (setOption != null) : "Parameter 'setOption' of method 'DeleteRefactoringData' must not be null";
        assert (options.contains((Object)setOption)) : "'setOption' not found: " + String.valueOf((Object)setOption);
        assert (edgeOptionsInfo != null) : "Parameter 'edgeOptionsInfo' of method 'DeleteRefactoringData' must not be null";
        assert (violating != null) : "Parameter 'violating' of method 'DeleteRefactoringData' must not be null";
        assert (recursiveElementChildrenOption != null) : "Parameter 'recursiveElementChildrenOption' of method 'DeleteRefactoringData' must not be null";
        this.m_kind = kind;
        this.m_elements = new ArrayList<Element>(elements);
        this.m_structureMode = structureMode;
        this.m_edgeOptions.addAll(options);
        this.m_edgeOption = setOption;
        this.m_edgeOptionsInfo = edgeOptionsInfo;
        this.m_violating = new HashSet<ParserDependency>(violating);
        this.m_recursiveElementChildrenOption = recursiveElementChildrenOption;
    }

    public DeleteRefactoringData(Kind kind, List<Element> elements, StructureMode structureMode, List<EdgeOption> options, EdgeOption setOption, String optionsInfo, Set<ParserDependency> violating) {
        assert (kind != null) : "Parameter 'kind' of method 'DeleteRefactoringData' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'DeleteRefactoringData' must not be empty";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'DeleteRefactoringData' must not be null";
        assert (options != null && !options.isEmpty()) : "Parameter 'options' of method 'DeleteRefactoringData' must not be empty";
        assert (setOption != null) : "Parameter 'setOption' of method 'DeleteRefactoringData' must not be null";
        assert (options.contains((Object)setOption)) : "'setOption' not found: " + String.valueOf((Object)setOption);
        assert (optionsInfo != null) : "Parameter 'optionsInfo' of method 'DeleteRefactoringData' must not be null";
        assert (violating != null) : "Parameter 'violating' of method 'DeleteRefactoringData' must not be null";
        this.m_kind = kind;
        this.m_elements = new ArrayList<Element>(elements);
        this.m_structureMode = structureMode;
        this.m_edgeOptions.addAll(options);
        this.m_edgeOption = setOption;
        this.m_edgeOptionsInfo = optionsInfo;
        this.m_recursiveElementChildrenOption = null;
        this.m_violating = new HashSet<ParserDependency>(violating);
    }

    public Kind getKind() {
        return this.m_kind;
    }

    public List<Element> getElements() {
        return Collections.unmodifiableList(this.m_elements);
    }

    public StructureMode getStructureMode() {
        return this.m_structureMode;
    }

    public List<EdgeOption> getEdgeOptions() {
        return this.m_edgeOptions;
    }

    public void setEdgeOption(EdgeOption option) {
        assert (option != null) : "Parameter 'option' of method 'setOption' must not be null";
        assert (this.m_edgeOptions.contains((Object)option)) : "'option' not found: " + String.valueOf((Object)option);
        this.m_edgeOption = option;
    }

    public EdgeOption getEdgeOption() {
        return this.m_edgeOption;
    }

    public String getEdgeOptionsInfo() {
        return this.m_edgeOptionsInfo;
    }

    public boolean showRecursiveElementChildrenOption() {
        return this.m_recursiveElementChildrenOption != null;
    }

    public boolean recursiveElementChildrenOptionIsReadOnly() {
        assert (this.m_recursiveElementChildrenOption != null) : "'m_recursiveElementChildrenOption' of method 'recursiveElementChildrenOptionIsReadOnly' must not be null";
        return this.m_recursiveElementChildrenOption.isReadOnly();
    }

    public void setIncludeRecursiveElementOption(boolean include) {
        assert (!this.recursiveElementChildrenOptionIsReadOnly()) : "Is read only";
        this.m_recursiveElementChildrenOption.setInclude(include);
    }

    public Set<ParserDependency> getViolating() {
        return Collections.unmodifiableSet(this.m_violating);
    }

    public boolean includeRecursiveElementChildren() {
        return this.m_recursiveElementChildrenOption != null && this.m_recursiveElementChildrenOption.include();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("### ").append(this.getClass().getSimpleName()).append(" [START] ###\n");
        builder.append("Structure mode: ").append((Object)this.m_structureMode);
        builder.append("\n");
        if (this.m_edgeOptionsInfo != null && !this.m_edgeOptionsInfo.isEmpty()) {
            builder.append("Edge options info: ").append(this.m_edgeOptionsInfo);
            builder.append("\n");
        }
        if (this.m_edgeOption != null) {
            builder.append("Edge option: ").append((Object)this.m_edgeOption);
            builder.append("\n");
        }
        if (this.m_recursiveElementChildrenOption != null) {
            builder.append("Recursive elements: ").append(this.m_recursiveElementChildrenOption);
            builder.append("\n");
        }
        builder.append(this.m_elements.size()).append(" element(s):");
        builder.append("\n");
        int i = 1;
        for (Element nextElement : this.m_elements) {
            builder.append("(").append(i).append(") ").append(nextElement);
            ++i;
            builder.append("\n");
        }
        if (!this.m_violating.isEmpty()) {
            builder.append(this.m_violating.size()).append(" violation(s):");
            builder.append("\n");
            int n = 1;
            for (ParserDependency nextParserDependency : this.m_violating) {
                builder.append("(").append(n).append(") ").append(nextParserDependency);
                ++n;
                builder.append("\n");
            }
        }
        builder.append("### ").append(this.getClass().getSimpleName()).append(" [END] ###");
        return builder.toString();
    }

    public static enum EdgeOption implements IStandardEnumeration
    {
        DELETE_PARSER_DEPENDENCIES,
        DELETE_PARSER_DEPENDENCIES_BASED_ON_ENDPOINTS,
        DELETE_VIOLATING_PARSER_DEPENDENCIES;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    public static enum Kind {
        DEPENDENCY,
        NODE;

    }

    public static final class RecursiveElementChildrenOption {
        private final boolean m_isReadOnly;
        private boolean m_include;

        public RecursiveElementChildrenOption(boolean isReadOnly, boolean include) {
            this.m_isReadOnly = isReadOnly;
            this.m_include = include;
        }

        boolean isReadOnly() {
            return this.m_isReadOnly;
        }

        boolean include() {
            return this.m_include;
        }

        void setInclude(boolean include) {
            assert (!this.m_isReadOnly) : "Is read only";
            this.m_include = include;
        }

        public String toString() {
            return (this.isReadOnly() ? "[READ ONLY] " : "") + (this.m_include ? " INCLUDE" : "NOT INCLUDE");
        }
    }
}

