/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.plugin;

import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.PluginIssueSeverity;
import com.hello2morrow.sonargraph.api.PluginIssueType;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.DynamicIssueId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginProviderId;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import java.util.Collections;
import java.util.List;

public final class PluginIssueId
extends DynamicIssueId
implements IPluginIssueId {
    public static final String ISSUE_TYPE_CLASS = "Plugin";
    private final SonargraphPlugin m_plugin;
    private final PluginProviderId m_pluginIssueProviderId;
    private final String m_id;
    private final String m_presentationName;
    private final PluginIssueSeverity m_severity;
    private final PluginIssueType m_type;

    public PluginIssueId(SonargraphPlugin plugin, PluginProviderId pluginIssueProviderId, String id, String presentationName, PluginIssueSeverity severity, PluginIssueType type) {
        assert (plugin != null) : "Parameter 'plugin' of method 'PluginIssueMetaId' must not be null";
        assert (pluginIssueProviderId != null) : "Parameter 'pluginIssueProviderId' of method 'PluginIssueMetaId' must not be null";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'PluginIssueMetaId' must not be empty";
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'PluginIssueMetaId' must not be empty";
        assert (severity != null) : "Parameter 'severity' of method 'PluginIssueMetaId' must not be null";
        assert (type != null) : "Parameter 'type' of method 'PluginIssueId' must not be null";
        this.m_plugin = plugin;
        this.m_pluginIssueProviderId = pluginIssueProviderId;
        this.m_id = id;
        this.m_presentationName = presentationName;
        this.m_severity = severity;
        this.m_type = type;
    }

    public PluginProviderId getProvider() {
        return this.m_pluginIssueProviderId;
    }

    @Override
    public String getProviderName() {
        return this.m_pluginIssueProviderId.getStandardName();
    }

    public String getPluginId() {
        return this.m_plugin.getId();
    }

    public String getId() {
        return this.m_id;
    }

    public PluginIssueType getType() {
        return this.m_type;
    }

    @Override
    public IssueCategory getCategory() {
        return IssueCategory.PLUGIN_BASED;
    }

    @Override
    public List<Severity> getSupportedSeverities() {
        return Collections.singletonList(Severity.valueOf(Severity.class, this.m_severity.name()));
    }

    @Override
    public IIssueId.PatternEditMode getPatternEditMode() {
        return IIssueId.PatternEditMode.valueOf(IIssueId.PatternEditMode.class, this.m_type.name());
    }

    @Override
    public boolean isParserModelIssue() {
        return false;
    }

    public String getStandardName() {
        return this.m_id;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_pluginIssueProviderId.hashCode();
        result = 31 * result + this.m_id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PluginIssueId other = (PluginIssueId)obj;
        return this.m_pluginIssueProviderId.equals(other.m_pluginIssueProviderId) && this.m_id.equals(other.m_id);
    }

    @Override
    public String getDebugInfo() {
        return super.getDebugInfo() + " defined in '" + this.m_pluginIssueProviderId.getIdentifier() + "'";
    }
}

